#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import Callable, NoReturn
from shinkensolutions.api.synchronizer import ShinkenObject


class FilterList(ShinkenObject):
    def __init__(self, translate, name_filter="", type_filter="input_string"):
        # type: (Callable, str, str)-> None
        super(FilterList, self).__init__(translate)
        self.content = None
        self.name_filter = name_filter
        self.type_filter = type_filter
    
    
    def set_content(self, to_set):
        # type: (ShinkenObject)-> NoReturn
        self.content = to_set
    
    
    def get_main_line_html(self):
        # type: ()-> str
        _to_return = ""
        if self.type_filter == 'input_string':
            _to_return = '''<td class="shinken-list-filter" data-object-type="shinken-list-filter" data-type="%s" data-name="%s">''' % (self.type_filter, self.name_filter)
        elif self.type_filter == 'select-single':
            _to_return = '''<td class="shinken-list-filter shinken-select-container" data-object-type="shinken-list-filter" data-type="%s" data-name="%s" data-state-selector="0">''' % (self.type_filter, self.name_filter)
        return _to_return
    
    
    def get_html(self, extra_content=""):
        # type: (str)-> str
        _to_return = [
            '''%s''' % (self.get_main_line_html()),
            '''<div class="shinken-list-filter-container">%s</div>''' % self.content.get_html(),
            '''</td>'''
        ]
        return ''.join(_to_return)
