SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR = (function ( self ) {
    self.DOM                          = {};
    self.TEST                         = {};
    self.TEST.JS                      = {};
    self.ACTION                       = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.option                   = function ( selector_dom_element, option_name ) {
        return selector_dom_element.querySelector( '.shinken-option[data-key-name="' + option_name + '"]' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnOption         = function ( timeout, dom_element, option_name, force_click ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnOption', option_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _option_dom = self.DOM.option( dom_element, option_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, _option_dom, force_click );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnOptionProperty = function ( timeout, property_name, selector_name, option_name, force_click ) {
        setTimeout( function () {
            self.ACTION.clickOnOption( 0, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.selector( property_name, selector_name ), option_name, force_click );
        }, timeout );
        return 500;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.isOptionState           = function ( timeout, selector_dom_element, option_name, state ) {
        setTimeout( function () {
            var _option_dom = self.DOM.option( selector_dom_element, option_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_SELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_UNSELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "0.18", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "pointer-events", "none", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.NOT_SELECTED_SELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgba(0, 0, 0, 0)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(0, 0, 0)", "selector option" );
                    break;
            }
        }, timeout );
        return 10;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR || {} );

SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST = {
    OPTION_STATE: {
        SELECTED_SELECTABLE    : "SELECTED_SELECTABLE",
        SELECTED_UNSELECTABLE  : "SELECTED_UNSELECTABLE",
        NOT_SELECTED_SELECTABLE: "NOT_SELECTED_SELECTABLE",
        UNKNOWN                : "UNKNOWN"
    }
};