SHINKEN.TOOLS.TEST_AUTO_LIST = (function ( self ) {
    self.DOM    = {};
    self.ACTION = {};
    self.TEST   = {};
    
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getErrorPanelPagination   = function () {
        return self.DOM.getMassActionContainer().querySelector( ".shinken-pagination" );
    };
    self.DOM.getErrorPanelHeader       = function () {
        return self.DOM.getMassActionContainer().querySelector( ".shinken-list-container-fix-header-filter" );
    };
    self.DOM.getErrorPanelTableElement = function () {
        return self.DOM.getMassActionContainer().querySelectorAll( ".shinken-list-tbody tr" );
    };
    self.DOM.filter                    = function ( dom_container, filter_name ) {
        return dom_container.querySelector( '.shinken-list-filter[data-name="' + filter_name + '"]' );
    };
    self.DOM.filterInput               = function ( dom_container, filter_name ) {
        return self.DOM.filter( dom_container, filter_name ).querySelector( '.shinken-input' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.filter                 = function ( timeout, dom_container, filter_name, filter_value ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.filter', filter_name + " -> " + filter_value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.filterInput( dom_container, filter_name ), filter_value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //self.ACTION.changeFilter = function ( filter_value ) {
    //    self.ACTION.clickOnInput();
    //    if ( _dom_action ) {
    //        SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 400, _dom_action, filter_value, true );
    //        return true;
    //    }
    //    return false;
    //};
    
    ////********************************************  SETTER GETTER   **************************************************//
    //self.ACTION.enterFilter          = function ( filter_name, value ) {
    //    MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.validation_rules = MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.validation_rules_not_focus;
    //    MANAGER.__instance_filter_distributor.getElement( filter_name ).setValue( value );
    //    MANAGER.__instance_filter_distributor.getElement( filter_name ).askComputeAfterChange();
    //};
    ////********************************************  TEST   **************************************************//
    //self.TEST.IsErrorListTableVisibe = function ( timeout, nb_total ) {
    //    setTimeout( function () {
    //        ____( SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( _timeout, document.querySelector( '#left-panel-error-content .shinken-list-container' ), "list zone error" ) );
    //    }, timeout );
    //    return 50;
    //};
    //self.TEST.columnNumber           = function ( timeout, nb_total ) {
    //    setTimeout( function () {
    //        SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.headers(), nb_total, "nb élement total de header" );
    //    }, timeout );
    //    return 50;
    //};
    //self.TEST.elementsNumber         = function ( timeout, nb_total, nb_new, nb_diff ) {
    //    setTimeout( function () {
    //        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-list-element-number" ), nb_total, "nb élement total de la liste" );
    //        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-new-list-element-number" ), nb_new, "nb élement total de la liste en nouveau" );
    //        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-diff-list-element-number" ), nb_diff, "nb élement total de la liste en difference" );
    //    }, timeout );
    //    return 50;
    //};
    //self.TEST.filterValidation       = function ( timeout, filter_name, value, nb_error_expected, _nb_warning_expected ) {
    //    setTimeout( function () {
    //        self.ACTION.enterFilter( filter_name, value );
    //        SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER.TEST.validation_value( 300, filter_name, nb_error_expected, _nb_warning_expected, value );
    //    }, timeout );
    //    return 1000;
    //};
    //self.TEST.massActionsOptions     = function ( timeout, nb_actions ) {
    //    setTimeout( function () {
    //        self.ACTION.switchMassActionSelectorState( 0 );
    //        var _options = self.DOM.getMassActionOptions();
    //        SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _options, nb_actions, "nb options" );
    //        for ( var i = 0, _size_i = _options.length; i < _size_i; i++ ) {
    //            self.TEST.massActionOptionCounter( _options[ i ] );
    //            SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( _options[ i ], 'mouseenter' );
    //        }
    //    }, timeout );
    //    return 100;
    //};
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIST || {} );

SHINKEN.TOOLS.TEST_AUTO_LIST_GENERIC = (function ( self ) {
    self.DOM                       = {};
    self.ACTION                    = {};
    self.TEST                      = {};
    //********************************************  DOM **************************************************//
    self.DOM.filter                = function ( filter_name ) {
        return document.querySelector( '.shinken-list-select-input[data-name="' + filter_name + '"]' );
    };
    self.DOM.filterInput           = function ( filter_name ) {
        return self.DOM.filter( filter_name ).querySelector( '.shinken-input' );
    };
    //********************************************  ACTION **************************************************//
    self.ACTION.clickOnInput       = function ( timeout, css_selector ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, document.querySelector( css_selector ) );
        }, timeout );
        return 200;
    };
    self.ACTION.moveAutoCursorDown = function ( timeout, filter_name, _avoid_next_phase ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___dispatchKeyEvent( self.DOM.filterInput( filter_name ), "keydown", 'ArrowDown', 40 );
        }, timeout );
        return 500;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.validation_value     = function ( timeout, filter_name, nb_error_expected, nb_warning_expected, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            if ( !value ) {
                value = _filter.component.input.getDomValue();
            }
            var _input = __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ? _filter.component.input.dom_element : _filter.component.input.dom_element_input;
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterError().getValue(), nb_error_expected, "Error pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterWarning().getValue(), nb_warning_expected, "Warning pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            if ( nb_error_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _input, "backgroundColor", "rgb(253, 3, 0)" );
            }
            else if ( nb_warning_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _input, "backgroundColor", "rgb(253, 132, 3)" );
            }
        }, timeout );
        return 1000;
    };
    self.TEST.hasValue             = function ( timeout, filter_name, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            var _input  = __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ? _filter.component.input.dom_element : _filter.component.input.dom_element_input;
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( _input, 'value', value, filter_name + " :" );
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIST_GENERIC || {} );

