SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT = (function ( self ) {
    self.DOM                                    = {};
    self.ACTION                                 = {};
    self.TEST                                   = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getLeftColumn                      = function () {
        return document.getElementById( "left-column" );
    };
    self.DOM.getRightColumn                     = function () {
        return document.getElementById( "right-column" );
    };
    self.DOM.getProperty                        = function ( property_name ) {
        return self.DOM.getRightColumn().querySelector( ".shinken-element-property-line[data-name=\"" + property_name + "\"]" );
    };
    self.DOM.getSelectPropertyOptions           = function ( property_name ) {
        return self.DOM.getProperty( property_name ).querySelectorAll( ".shinken-option" );
    };
    self.DOM.getSelectPropertySpecificOption    = function ( property_name, option_to_get ) {
        return self.DOM.getProperty( property_name ).querySelector( ".shinken-option[data-key-name=\"" + option_to_get + "\"]" );
    };
    self.DOM.getPropertyInput                   = function ( property_name ) {
        return self.DOM.getProperty( property_name ).querySelector( ".shinken-input" );
    };
    self.DOM.propertyHelpButton                 = function ( property_name ) {
        return self.DOM.getProperty( property_name ).querySelector( ".shinken-tag-help" );
    };
    self.DOM.propertyLabel                      = function ( property_name ) {
        return self.DOM.getProperty( property_name ).querySelector( ".shinken-label-title" );
    };
    self.DOM.propertyHelpLabel                  = function () {
        return self.DOM.getLeftColumn().querySelector( ".shinken-help-name" );
    };
    self.DOM.propertyDiff                       = function ( property_name ) {
        return self.DOM.getRightColumn().querySelector( "#tr-change-" + property_name );
    };
    self.DOM.propertyDiffLabel                  = function ( property_name ) {
        return self.DOM.propertyDiff( property_name ).querySelector( ".shinken-property-name-cell" );
    };
    self.DOM.propertyPropose                    = function ( property_name ) {
        return self.DOM.getRightColumn().querySelector( ".shinken-data-row[data-name=\"" + property_name + "\"]" );
    };
    self.DOM.propertyProposeLabel               = function ( property_name ) {
        return self.DOM.propertyPropose( property_name ).querySelector( ".shinken-col-property" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnPropertyHelpButton       = function ( timeout, property_name ) {
        var _to_return = 300;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnPropertyHelpButton', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.propertyHelpButton( property_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( 0, _dom, 'mouseenter' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.propertyIsProtected               = function ( timeout, property_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.propertyIsProtected', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var property_input = self.DOM.getPropertyInput( property_name );
            if ( property_input.getAttribute( "type" ) !== "shinken-password" ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( property_name + " is not protected" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.selectPropertyOptionIsLocked      = function ( timeout, property_name, option_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.selectPropertyOptionIsLocked', property_name + "-" + option_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var option = self.DOM.getSelectPropertySpecificOption( property_name, option_name );
            if ( !option.classList.contains( "shinken-option-locked" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Option " + option_name + " is not locked on property " + property_name );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.labelProperty                     = function ( timeout, property_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.labelProperty', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.propertyLabel( property_name ), label );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.helpLabelProperty                 = function ( timeout, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.helpLabelProperty', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.propertyHelpLabel(), label, "HELP PROPERTY" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.helpLabelPropertyAndPropertyLabel = function ( timeout, property_name, label ) {
        var _to_return = 300 + 50 + 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.notesUrlLabel', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            var _timeout = SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT.ACTION.clickOnPropertyHelpButton( 0, property_name );
            _timeout     = SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT.TEST.labelProperty( _timeout, property_name, label );
            SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT.TEST.helpLabelProperty( _timeout, label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.labelPropertyDiff                 = function ( timeout, property_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.labelPropertyDiff', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.propertyDiffLabel( property_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.labelPropertyPropose              = function ( timeout, property_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.labelPropertyPropose', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.propertyProposeLabel( property_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT || {} );

