SHINKEN.TOOLS.TEST_AUTO_PROPERTY_DATA = (function ( self ) {
    self.DOM                              = {};
    self.TEST                             = {};
    self.ACTION                           = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.line                         = function ( property_name ) {
        return MANAGER.__instance_property_distributor.getDataWithName( property_name ).dom_element;
    };
    self.DOM.mainInput                    = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-action .shinken-input' );
    };
    self.DOM.inheritanceButtonValue       = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .shinken-heritance-value' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.addNewData                = function ( timeout, name, value ) {
        setTimeout( function () {
            var _new_data                                                     = MANAGER.EventManager.clickOnAddNewLocalMacro();
            _new_data.component_input.current_value                           = value;
            _new_data.dom_element.querySelector( ".shinken-input-key" ).value = name;
            if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( name ) ) {
                _new_data.is_protected                                                                 = true;
                _new_data.dom_element.querySelector( '.shinken-input[type="shinken-password"]' ).value = value;
            }
            else {
                _new_data.dom_element.querySelector( '.shinken-input[type="text"]' ).value = value;
            }
            _new_data.askComputeKeyAfterChange();
            _new_data.askComputeAfterChange();
        }, timeout );
        return 1000;
    };
    self.ACTION.setKeyValue               = function ( timeout, property_name, value ) {
        setTimeout( function () {
            MANAGER.__instance_property_distributor.getElement( property_name ).setKeyValueFromUser( value );
        }, timeout );
        return 1000;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.isState                     = function ( timeout, property_name, state ) {
        setTimeout( function () {
            switch ( state ) {
                case PROPERTY.CONST.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.line( property_name ) );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'state', state, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( MANAGER.__instance_property_distributor.getDataWithName( property_name ), 'state', state, '[--2--]' );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.placeholder                 = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _input = self.DOM.mainInput( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _input.placeholder, text_expected, property_name + ": placeholderContent -> " );
        }, timeout );
        return 50;
    };
    self.TEST.inheritanceButtonValueLabel = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.inheritanceButtonValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom.innerText, text_expected, "validMainInputContentDisplay" );
        }, timeout );
        return 50;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY_DATA || {} );