SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT      = (function ( self ) {
    self.DOM                                    = {};
    self.TEST                                   = {};
    self.TEST.JS                                = {};
    self.ACTION                                 = {};
    self.ACTION.IFRAME                          = {};
    self.TEST.EXTERNAL_LINKS                    = {};
    self.STATUS_LINE_NUMBER                     = {
        STATE_DISPLAY: {
            OK     : 0,
            WARNING: 1,
            ERROR  : 2
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.editButtonsContainer               = function ( in_iframe ) {
        return SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.pageContainer( in_iframe ).querySelector( "#id-shinken-weather-edit-buttons-container" );
    };
    self.DOM.slidePanelFormContainer            = function ( in_iframe ) {
        var _document = in_iframe ? SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.IFRAME.getIframe() : document;
        return _document.querySelector( ".shinken-weather-form-container" );
    };
    self.DOM.getTooltip                         = function ( in_iframe ) {
        var _document = in_iframe ? SHINKEN.TOOLS.TEST_AUTO_WEATHER.DOM.IFRAME.getIframe() : document;
        return _document.getElementById( "shi-tip" );
    };
    self.DOM.modeEditButton                     = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( '.shinken-button[data-name="enter_in_edit_mode"]' );
    };
    self.DOM.saveButton                         = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="enter_in_save_mode"]' );
    };
    self.DOM.cancelButton                       = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="cancel_edit_mode_weather"]' );
    };
    self.DOM.toggleDisplayOfWidgetsIssuesButton = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="toggle-display-of-widgets-with-issues"]' );
    };
    self.DOM.externalLinksButton                = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( '.shinken-button[data-name="external_links_weather"]' );
    };
    self.DOM.popUpExternalLinks                 = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( '.shinken-weather-external-links-container' );
    };
    self.DOM.previewButton                      = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="preview_weather"]' );
    };
    self.DOM.backToPreviousPreview              = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-button[data-name="back_to_previous_preview"]' );
    };
    self.DOM.getProblemsContainer               = function () {
        return document.querySelector( '.shinken-weather-error-message' );
    };
    self.DOM.getAllErrorsProblems               = function () {
        var _dom_problem_container = self.DOM.getProblemsContainer();
        if ( !_dom_problem_container ) {
            return [];
        }
        return _dom_problem_container.querySelectorAll( 'li.shinken-error-status' );
    };
    self.DOM.getAllWarningsProblems             = function () {
        var _dom_problem_container = self.DOM.getProblemsContainer();
        if ( !_dom_problem_container ) {
            return [];
        }
        return _dom_problem_container.querySelectorAll( 'li.shinken-warning-status' );
    };
    self.DOM.formTextArea                       = function ( in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '#id-shinken-output-json' );
    };
    self.DOM.getLineNumber                      = function ( number, in_iframe ) {
        return self.DOM.slidePanelFormContainer( in_iframe ).querySelector( '.shinken-textarea-line-nums' ).querySelector( '.shinken-line-number[data-number="' + number + '"]' );
    };
    self.DOM.formTextAreaErrorsProblems         = function () {
        return self.DOM.formTextArea().querySelectorAll( '.' + SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR );
    };
    self.DOM.getElement                         = function ( type_element, in_iframe ) {
        switch ( type_element ) {
            case "button_mode_edit":
                return self.DOM.modeEditButton( in_iframe );
            case "button_back_to_previous_preview":
                return self.DOM.backToPreviousPreview( in_iframe );
            case "button_external_links":
                return self.DOM.externalLinksButton( in_iframe );
            case "button_save":
                return self.DOM.saveButton( in_iframe );
            case "preview_weather":
                return self.DOM.previewButton( in_iframe );
            case "popup_external_links":
                return self.DOM.popUpExternalLinks( in_iframe );
            case "cancel_edit_mode":
                return self.DOM.cancelButton( in_iframe );
            case "toggle_display_widgets_withs_issues":
                return self.DOM.toggleDisplayOfWidgetsIssuesButton( in_iframe );
        }
    };
    self.DOM.getExternalLinks                   = function ( in_iframe ) {
        return self.DOM.editButtonsContainer( in_iframe ).querySelector( '.shinken-external-links-table' );
    };
    self.DOM.getExternalLinkByUUID              = function ( in_iframe, link_uuid ) {
        return self.DOM.getExternalLinks( in_iframe ).querySelector( '.shinken-external-link-row[data-link-uuid="' + link_uuid + '"]' );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.validationCase                           = function ( timeout, value_to_test, nb_errors_window, nb_warnings_window, nb_errors_json, nb_warnings_json ) {
        var _to_return     = 15000;
        nb_errors_window   = nb_errors_window || 0;
        nb_warnings_window = nb_warnings_window || 0;
        nb_errors_json     = typeof nb_errors_json === 'undefined' ? nb_errors_window : nb_errors_json;
        nb_warnings_json   = typeof nb_warnings_json === 'undefined' ? nb_warnings_window : nb_warnings_json;
        var _uuid          = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "validationCase", [value_to_test, nb_errors_window, nb_warnings_window, nb_errors_json, nb_warnings_json].join( " - " ) );
        setTimeout( function () {
            var _timeout_temp = 0;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( false );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, 'button_mode_edit' );
            _timeout_temp += self.ACTION.setJSONInForm( _timeout_temp, false, false, "TEXT XSS", value_to_test );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "preview_weather" );
            _timeout_temp += SHINKEN.TOOLS.TEST_AUTO.ACTION.do_JS_action( _timeout_temp, "CONTROLLER.Weather.current_page.json_editor.updateHtml()", 2000 );
            _timeout_temp += self.TEST.countProblemsInWindow( _timeout_temp, nb_errors_window, nb_warnings_window );
            _timeout_temp += self.TEST.countProblemsInJson( _timeout_temp, nb_errors_json, nb_warnings_json );
            _timeout_temp += SHINKEN.TOOLS.TEST_AUTO_XSS.isFunctionExisting( _timeout_temp );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.validationJsonInvalid                    = function ( timeout, comma_index_removed, line_error_number ) {
        var _to_return = 2000 + 1000 + 2000 + 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "validationCase", comma_index_removed + " - " + line_error_number );
        setTimeout( function () {
            var _timeout_temp = 0;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( false );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, 'button_mode_edit' );
            _timeout_temp += self.ACTION.setJSONInvalidInForm( _timeout_temp, comma_index_removed );
            _timeout_temp += self.ACTION.clickOnButton( _timeout_temp, "preview_weather" );
            _timeout_temp += 2000; //NEEDED BECAUSE THE COMPUTE LINE IS TIMEOUT WITH 1000
            _timeout_temp += self.TEST.lineNumberStatus( _timeout_temp, line_error_number, self.STATUS_LINE_NUMBER.STATE_DISPLAY.ERROR );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.setDoLog( true );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.lineNumberStatus                         = function ( timeout, line_error_number, status_to_test ) {
        var _to_return = 400;
        setTimeout( function () {
            var _dom = self.DOM.getLineNumber( line_error_number );
            switch ( status_to_test ) {
                case self.STATUS_LINE_NUMBER.STATE_DISPLAY.ERROR:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, 'background-color', 'rgb(255, 0, 0)' );
                    break;
            }
        }, timeout );
        return _to_return;
    };
    self.TEST.countProblemsInWindow                    = function ( timeout, nb_errors_expected, nb_warnings_expected, skip_visibility_test ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "countProblemsInWindow" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( skip_visibility_test ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.visibility( 0, self.DOM.getProblemsContainer(), "container de message", !!(nb_errors_expected) );
            }
            var _doms_error   = self.DOM.getAllErrorsProblems();
            var _doms_warning = self.DOM.getAllWarningsProblems();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _doms_error, nb_errors_expected, "number errors" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _doms_warning, nb_warnings_expected, "number warnings" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.countProblemsInJson                      = function ( timeout, nb_errors_expected, nb_warnings_expected ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "countProblemsInJson" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.formTextAreaErrorsProblems(), nb_errors_expected, "JSON => number errors" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.EXTERNAL_LINKS.tooltipOfLinkContainsText = function ( timeout, text, in_iframe ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.EXTERNAL_LINKS.tooltipOfLinkContainsText' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = DOM.Service.createElement( "div", {}, text );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( self.DOM.getTooltip( in_iframe ), _dom_element, "text dans le tooltip" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.resetJSON                              = function ( timeout ) {
        var _to_return = 11000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "reset", "" );
        setTimeout( function () {
            var _temp_timeout = 0;
            _temp_timeout += self.ACTION.clickOnButton( _temp_timeout + timeout, "button_mode_edit" );
            _temp_timeout += self.ACTION.setJSONInForm( _temp_timeout + timeout, "", true );
            _temp_timeout += self.ACTION.clickOnButton( _temp_timeout + timeout, "button_save" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnButton                          = function ( timeout, button_name, in_iframe ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnButton", button_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_button = self.DOM.getElement( button_name, in_iframe );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom_button );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.IFRAME.clickOnButton                   = function ( timeout, button_name ) {
        return self.ACTION.clickOnButton( timeout, button_name, true );
    };
    self.ACTION.setJSONInForm                          = function ( timeout, extra_step, is_reset, info, value_to_force, in_iframe ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setJSONInForm", info );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_textarea       = self.DOM.formTextArea( in_iframe );
            _dom_textarea.innerText = JSON.stringify( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_JSON.GETTER.template( extra_step, is_reset, value_to_force ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.IFRAME.setJSONInForm                   = function ( timeout, extra_step, is_reset, info, value_to_force ) {
        return self.ACTION.setJSONInForm( timeout, extra_step, is_reset, info, value_to_force, true );
    };
    self.ACTION.IFRAME.createJSONInForm                = function ( timeout, name_title, user_name ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setJSONInForm2", name_title );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_textarea       = self.DOM.formTextArea( true );
            _dom_textarea.innerText = JSON.stringify( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_JSON.GETTER.template2( name_title, user_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setJSONInvalidInForm                   = function ( timeout, index_comma_to_remove ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setJSONInForm", "TEST MISSING COMMA" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _index                        = SHINKEN.TOOLS.STRING.indexesOf( self.DOM.formTextArea().innerHTML, "," )[ index_comma_to_remove ];
            var _new_html                     = self.DOM.formTextArea().innerHTML.substring( 0, _index - 1 ) + self.DOM.formTextArea().innerHTML.substring( _index + 1, self.DOM.formTextArea().innerHTML.length );
            self.DOM.formTextArea().innerHTML = _new_html;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.mouseEnterLink                         = function ( timeout, link_uuid, in_iframe ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( timeout, self.DOM.getExternalLinkByUUID( in_iframe, link_uuid ), 'mouseenter' );
        }, timeout );
        return 5000;
    };
    self.ACTION.IFRAME.mouseEnterLink                  = function ( timeout, link_uuid ) {
        return self.ACTION.mouseEnterLink( timeout, link_uuid, true );
    };
    //********************************************  CONSTANT **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT || {} );
SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_JSON = (function ( self ) {
    self.GETTER                    = {};
    //********************************************  GETTER   **************************************************//
    self.GETTER.template           = function ( extra_step, is_reset, value_to_force ) {
        var _to_return    = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE_2 );
        var _switch_value = __shinken_test_type + "-" + __phase;
        if ( extra_step ) {
            _switch_value = _switch_value + "-" + extra_step;
        }
        if ( is_reset ) {
            _switch_value = "reset";
        }
        switch ( _switch_value ) {
            case "DEV_METEO-1":
                _to_return = {
                    "grids": [
                        {
                            "type"         : "grid",
                            "grid_elements": [
                                {
                                    "position_x": 0,
                                    "position_y": 0,
                                    "width"     : "default",
                                    "height"    : "default",
                                    "content"   : {
                                        "type"  : "title_widget",
                                        "layout": {
                                            "information_to_display": {
                                                "title_area": {
                                                    "label": "toto"
                                                }
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    ],
                    "users": {
                        "owner_user": {
                            "user_uuid": "xxxxx"
                        }
                    }
                    
                };
                
                break;
            case "00173-2":
            case "00173-3-1":
            case "00173-3-4":
            case "00173-4-1":
            case "00173-4-3":
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                break;
            case "00173-1":
            case "00173-3-2":
            case "00173-4-2":
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( {
                    "position_x": 0,
                    "position_y": 4,
                    "width"     : 15,
                    "height"    : 5,
                    "content"   : {
                        "type": "weather_widget",
                        "item": {
                            "item_uuid": "00000000000000000000000000000001",
                            "item_type": "host"
                        }
                    }
                } );
                break;
            case "00173-3-3":
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( {
                    "position_x": 0,
                    "position_y": 4,
                    "width"     : 15,
                    "height"    : 5,
                    "content"   : {
                        "type": "weather_widget",
                        "item": {
                            "item_uuid": "00000000000000000000000000000001",
                            "item_type": "host"
                        }
                    }
                } );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( {
                    "position_x": 15,
                    "position_y": 4,
                    "width"     : 15,
                    "height"    : 5,
                    "content"   : {
                        "type": "weather_widget",
                        "item": {
                            "item_uuid": "00000000000000000000000000000003",
                            "item_type": "host"
                        }
                    }
                } );
                break;
            case "00173-5":
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "external_links" ][ "links" ].push( {
                    "authentication_needed" : true,
                    "info_bar"              : {
                        "position"        : "top",
                        "logo_displayed"  : true,
                        "background_color": "#343434",
                        "refresh"         : {
                            "chrono_displayed"         : true,
                            "generation_time_displayed": false
                        }
                    },
                    "link_name"             : "external_test_auto",
                    "link_uuid"             : "00000000000000000000000000000001",
                    "link_external_part_url": "external_link",
                    "link_base_url"         : ""
                } );
                break;
            case "00175-1":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "height" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "height" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "height" ] = value_to_force;
                break;
            case "00175-2":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "width" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "width" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "width" ] = value_to_force;
                break;
            case "00175-3":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "position_x" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "position_x" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "position_x" ] = value_to_force;
                break;
            case "00175-4":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "position_y" ] = Array.isArray( value_to_force ) ? value_to_force[ 0 ] : value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "position_y" ] = Array.isArray( value_to_force ) ? value_to_force[ 1 ] : value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "position_y" ] = Array.isArray( value_to_force ) ? value_to_force[ 2 ] : value_to_force;
                break;
            case "00175-5":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "type" ] = Array.isArray( value_to_force ) ? value_to_force[ 0 ] : value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "type" ] = Array.isArray( value_to_force ) ? value_to_force[ 1 ] : value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "type" ] = Array.isArray( value_to_force ) ? value_to_force[ 2 ] : value_to_force;
                break;
            case "00175-6":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = value_to_force;
                break;
            case "00175-7":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_color" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_color" ] = value_to_force;
                break;
            case "00175-8":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "font_zoom_percent" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "font_zoom_percent" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "font_zoom_percent" ]  = value_to_force;
                break;
            case "00175-9":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "displayed" ]  = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ][ "displayed" ] = value_to_force;
                break;
            case "00175-10":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "width_percent" ]  = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ][ "width_percent" ] = value_to_force;
                break;
            case "00175-11":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_align" ] = value_to_force;
                break;
            case "00175-12":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "item" ][ "item_type" ] = value_to_force;
                break;
            case "00175-13":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "background" ] = value_to_force;
                break;
            case "00175-14":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ] = value_to_force;
                break;
            case "00175-15":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = value_to_force;
                break;
            case "00175-16":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = value_to_force;
                break;
            case "00175-17":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "sla_area" ][ "displayed" ] = value_to_force;
                break;
            case "00175-18":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "sla_area" ][ "show_icon" ] = value_to_force;
                break;
            case "00175-19":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "property_used_as_name" ] = value_to_force;
                break;
            case "00175-20":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "nb_lines_max" ] = value_to_force;
                break;
            case "00175-21":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "vertical_align" ] = value_to_force;
                break;
            case "00175-22":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "width" ]   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "width" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "width" ]     = value_to_force;
                break;
            case "00175-23":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "height" ]   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "height" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "height" ]     = value_to_force;
                break;
            case "00175-24":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "background" ] = value_to_force;
                break;
            case "00175-25":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ] = value_to_force;
                break;
            case "00175-26":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = value_to_force;
                break;
            case "00175-27":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "sla_area" ][ "displayed" ]       = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "sla_area" ][ "show_icon" ]       = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "displayed" ]    = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ][ "displayed" ]   = value_to_force;
                break;
            case "00175-28":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "property_used_as_name" ] = value_to_force;
                break;
            case "00175-29":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "nb_lines_max" ] = value_to_force;
                break;
            case "00175-30":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "vertical_align" ] = value_to_force;
                break;
            case "00175-31":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "name_area" ][ "font_zoom_percent" ]    = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "font_zoom_percent" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "font_zoom_percent" ]     = value_to_force;
                break;
            case "00175-32":
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_color" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_color" ]     = value_to_force;
                break;
            case "00175-33":
                _to_return[ "external_links" ][ "default_link" ][ "link_base_url" ]          = value_to_force;
                _to_return[ "external_links" ][ "default_link" ][ "link_external_part_url" ] = value_to_force;
                break;
            case "00175-34":
                _to_return[ "external_links" ][ "default_link" ][ "authentication_needed" ] = value_to_force;
                break;
            case "00175-35":
                _to_return[ "external_links" ][ "default_link" ][ "info_bar" ][ "background_color" ] = value_to_force;
                break;
            case "00175-36":
                _to_return[ "external_links" ][ "default_link" ][ "info_bar" ][ "logo_displayed" ]                         = value_to_force;
                _to_return[ "external_links" ][ "default_link" ][ "info_bar" ][ "refresh" ][ "chrono_displayed" ]          = value_to_force;
                _to_return[ "external_links" ][ "default_link" ][ "info_bar" ][ "refresh" ][ "generation_time_displayed" ] = value_to_force;
                break;
            case "00175-37":
                _to_return[ "external_links" ][ "default_link" ][ "info_bar" ][ "position" ] = value_to_force;
                break;
            case "00175-38":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": value_to_force } );
                break;
            case "00175-39":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "authentication_needed" ]                                = value_to_force;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ]                                             = {};
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ][ "logo_displayed" ]                         = value_to_force;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ][ "refresh" ]                                = {};
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ][ "refresh" ][ "chrono_displayed" ]          = value_to_force;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ][ "refresh" ][ "generation_time_displayed" ] = value_to_force;
                break;
            case "00175-40":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "link_base_url" ]          = value_to_force;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "link_external_part_url" ] = value_to_force;
                break;
            case "00175-41":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ]                       = {};
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ][ "background_color" ] = value_to_force;
                break;
            case "00175-42":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ]               = {};
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ][ "position" ] = value_to_force;
                break;
            case "00175-43":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "link_protocol" ] = value_to_force;
                break;
            case "00175-44":
                _to_return[ "external_links" ][ "default_link" ][ "link_protocol" ] = value_to_force;
                break;
            case "00175-45":
                _to_return[ "notifications" ][ "sound" ][ "enabled" ]             = value_to_force;
                _to_return[ "notifications" ][ "visual" ][ "blink" ][ "enabled" ] = value_to_force;
                break;
            case "00175-46":
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "sound" ][ "enabled" ]             = value_to_force;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ] = value_to_force;
                break;
            case "00175-47":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "notifications" ][ "sound" ][ "enabled" ]             = value_to_force;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ] = value_to_force;
                break;
            case "00176-1":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "labelss" ] = "test_auto";
                break;
            case "00185-1":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ] = value_to_force;
                //_to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ]                   = value_to_force;
                //_to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ] = value_to_force;
                //_to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ]     = value_to_force;
                break;
            case "00185-2":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ]   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ]     = value_to_force;
                break;
            case "00185-3":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ][ "layout" ]   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "content" ][ "layout" ]     = value_to_force;
                break;
            case "00185-4":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "weather_widget_layout" ][ "content" ]   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ] = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "title_widget_layout" ][ "content" ]     = value_to_force;
                break;
            case "00185-5":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ]                    = value_to_force;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ]                   = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ]  = value_to_force;
                _to_return[ "grids" ][ 0 ][ "layouts" ][ "separator_widget_layout" ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ] = value_to_force;
                break;
            case "00194-1-1":
            case "00194-3-1":
                // ALL TEST FOR SEPARATOR WIDGET
                // TEST GOOD DIPLAY
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                break;
            case "00194-1-2":
                // TEST LEFT AREA IS NOT VISIBLE WITH PARAM DISPLAY
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "displayed" ] = false;
                break;
            case "00194-1-3":
                // TEST LEFT AREA IS NOT VISIBLE WITH PARAM WIDTH_PERCENT
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "displayed" ]     = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "width_percent" ] = 0;
                break;
            case "00194-1-4":
                // TEST RIGHT AREA IS NOT VISIBLE WITH PARAM DISPLAY
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "width_percent" ] = 20;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ][ "displayed" ]    = false;
                break;
            case "00194-1-5":
                // TEST RIGHT AREA IS NOT VISIBLE WITH PARAM WIDTH_PERCENT
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ][ "displayed" ]     = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "right_area" ][ "width_percent" ] = 0;
                break;
            case "00194-2-1":
                // TEST TITLE_AREA IF THE COLOR SWITCH BLACK TO RED
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_color" ] = "FF0000";
                break;
            case "00194-3-2":
                // TEST TITLE_AREA IF TEXT_ALIGN LEFT WORK
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_align" ] = "left";
                break;
            case "00194-3-3":
                // TEST TITLE_AREA IF TEXT_ALIGN RIGHT WORK
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "text_align" ] = "right";
                break;
            case "00194-1-9":
                // TEST FONT ZOOM PERCENT
                _to_return = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( self.TEMPLATE_SEPARATOR_WIDGET );
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "font_zoom_percent" ] = 50;
                break;
            case "00201-1-1":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "status_then_context";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00201-1-2":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "quality_service_icon";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "status_then_context";
                break;
            case "00201-1-3":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "only_status";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00201-1-4":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "context_then_status";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00201-1-5":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "status_context_from_webui";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00201-1-6":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "status_context_from_webui";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = false;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00201-1-7":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "status_context_from_webui";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "sla_area" ][ "displayed" ]       = false;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00201-1-8":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "icon_type" ] = "status_context_from_webui";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "top_right_area" ][ "displayed" ] = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "sla_area" ][ "displayed" ]       = true;
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "icon_type" ]      = "quality_service_icon";
                break;
            case "00205-1-1":
                _to_return[ "users" ][ "owner_user" ][ "user_name" ] = "";
                _to_return[ "users" ][ "owner_user" ][ "user_uuid" ] = "";
                break;
            case "00208-1-1":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 2 ][ "content" ][ "item" ][ "item_uuid" ]                                              = "AUTO_TEST_FAIL_WARNING";
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 1 ][ "content" ][ "layout" ][ "information_to_display" ][ "left_area" ][ "displayed" ] = "FAIL_TYPE";
                break;
            case "00209-1-1":
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                break;
            case "00217-5":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( {
                    "position_x": 15,
                    "position_y": 6,
                    "width"     : 15,
                    "height"    : 5,
                    "content"   : {
                        "type": "weather_widget",
                        "item": {
                            "item_uuid": "06000000000000000000000000000000",
                            "item_type": "cluster"
                        }
                    }
                } );
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "authentication_needed" ] = true;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ]              = {};
                break;
            case "00217-11":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ].push( {
                    "position_x": 15,
                    "position_y": 6,
                    "width"     : 15,
                    "height"    : 5,
                    "content"   : {
                        "type": "weather_widget",
                        "item": {
                            "item_uuid": "06000000000000000000000000000000",
                            "item_type": "cluster"
                        }
                    }
                } );
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "authentication_needed" ] = false;
                _to_return[ "external_links" ][ "links" ][ 0 ][ "info_bar" ]              = {};
                break;
            case "00231-1":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = "TEST-AUTO-00231";
                _to_return[ "notifications" ][ "sound" ][ "enabled" ]                                                                              = true;
                _to_return[ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                                                                  = true;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "sound" ][ "enabled" ]                                        = true;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                            = true;
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                _to_return[ "external_links" ][ "links" ][ 0 ][ "link_uuid" ] = "002311";
                break;
            case "00231-2":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = "TEST-AUTO-00231";
                _to_return[ "notifications" ][ "sound" ][ "enabled" ]                                                                              = false;
                _to_return[ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                                                                  = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "sound" ][ "enabled" ]                                        = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                            = false;
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                break;
            case "00231-3":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = "TEST-AUTO-00231";
                _to_return[ "notifications" ][ "sound" ][ "enabled" ]                                                                              = false;
                _to_return[ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                                                                  = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "sound" ][ "enabled" ]                                        = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                            = false;
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                break;
            case "00231-4":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = "TEST-AUTO-00231";
                _to_return[ "notifications" ][ "sound" ][ "enabled" ]                                                                              = false;
                _to_return[ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                                                                  = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "sound" ][ "enabled" ]                                        = true;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                            = true;
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                break;
            case "00231-5":
                _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = "TEST-AUTO-00231";
                _to_return[ "notifications" ][ "sound" ][ "enabled" ]                                                                              = false;
                _to_return[ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                                                                  = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "sound" ][ "enabled" ]                                        = false;
                _to_return[ "external_links" ][ "default_link" ][ "notifications" ][ "visual" ][ "blink" ][ "enabled" ]                            = false;
                _to_return[ "external_links" ][ "links" ].push( { "link_name": "test_auto" } );
                break;
            
        }
        return _to_return;
    };
    self.GETTER.template2          = function ( name, user_name ) {
        var _to_return                                                                                                                     = SHINKEN.TOOLS.DICT.clone( self.TEMPLATE_2 );
        _to_return[ "grids" ][ 0 ][ "grid_elements" ][ 0 ][ "content" ][ "layout" ][ "information_to_display" ][ "title_area" ][ "label" ] = name;
        if ( user_name ) {
            _to_return[ "users" ][ "owner_user" ][ "user_name" ] = user_name;
            _to_return[ "users" ][ "owner_user" ][ "user_uuid" ] = "";
        }
        
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    self.TEMPLATE                  = {
        "grids"         : [
            {
                "type"         : "grid",
                "grid_elements": [
                    {
                        "position_y": 0,
                        "position_x": 0,
                        "content"   : {
                            "type"  : "title_widget",
                            "layout": {
                                "information_to_display": {
                                    "title_area": {
                                        "label": "DATACENTER"
                                    }
                                }
                            }
                        }
                        
                    }
                ]
            }
        ],
        "external_links": {
            "default_link": {
                "info_bar"     : {
                    "refresh": {}
                },
                "notifications": {
                    "sound" : {
                        "enabled": "default"
                    },
                    "visual": {
                        "blink": {
                            "enabled": "default"
                        }
                    }
                }
            }, "links"    : []
            
        },
        "notifications" : {
            "sound" : {
                "enabled": "default"
            },
            "visual": {
                "blink": {
                    "enabled": "default"
                }
            }
        }
    };
    self.TEMPLATE_2                = {
        "grids"         : [
            {
                "type"         : "grid",
                "grid_elements": [
                    {
                        "position_x": 0,
                        "position_y": 0,
                        "content"   : {
                            "type"  : "title_widget",
                            "layout": {
                                "information_to_display": {
                                    "title_area": {
                                        "label": "DATACENTER"
                                    }
                                }
                            }
                        }
                    },
                    {
                        "position_x": 0,
                        "position_y": 3,
                        "content"   : {
                            "type"  : "separator_widget",
                            "layout": {
                                "information_to_display": {
                                    "left_area" : {},
                                    "title_area": {
                                        "label": "DATA CENTER CENTRE"
                                    },
                                    "right_area": {}
                                }
                            }
                        }
                    },
                    {
                        "position_x": 0,
                        "position_y": 6,
                        "content"   : {
                            "type"  : "weather_widget",
                            "item"  : {
                                "item_uuid": "00000000000000000000000000000001",
                                "item_name": "00001_test_auto",
                                "item_type": "host"
                            },
                            "layout": {
                                "information_to_display": {
                                    "left_area"     : {},
                                    "top_right_area": {},
                                    "sla_area"      : {},
                                    "name_area"     : {}
                                }
                            }
                        }
                    }
                ],
                "layouts"      : {
                    "weather_widget_layout"  : {
                        "content": {
                            "layout": {
                                "information_to_display": {
                                    "left_area"     : {},
                                    "top_right_area": {},
                                    "sla_area"      : {},
                                    "name_area"     : {}
                                }
                            }
                        }
                    },
                    "separator_widget_layout": {
                        "content": {
                            "layout": {
                                "information_to_display": {
                                    "left_area" : {},
                                    "title_area": {},
                                    "right_area": {}
                                }
                            }
                        }
                    },
                    "title_widget_layout"    : {
                        "content": {
                            "layout": {
                                "information_to_display": {
                                    "title_area": {}
                                }
                            }
                        }
                    }
                }
            }
        ],
        "external_links": {
            "default_link": {
                "info_bar"     : {
                    "refresh": {}
                },
                "notifications": {
                    "sound" : {
                        "enabled": "default"
                    },
                    "visual": {
                        "blink": {
                            "enabled": "default"
                        }
                    }
                }
            },
            "links"       : []
        },
        "users"         : {
            "owner_user": {
                "user_uuid": "35000000000000000000000000000000"
            }
        },
        "notifications" : {
            
            "sound" : {
                "enabled": "default"
            },
            "visual": {
                "blink": {
                    "enabled": "default"
                }
            }
            
        }
    };
    self.TEMPLATE_SEPARATOR_WIDGET = {
        "position_x": 0,
        "position_y": 3,
        "width"     : "default",
        "height"    : "default",
        "content"   : {
            "type"  : "separator_widget",
            "layout": {
                "information_to_display": {
                    "left_area" : {
                        "displayed"    : true,
                        "width_percent": 20
                    },
                    "title_area": {
                        "label"            : "DATA CENTER CENTRE",
                        "font_zoom_percent": 100,
                        "text_color"       : "black",
                        "text_align"       : "center"
                    },
                    "right_area": {
                        "displayed"    : true,
                        "width_percent": 20
                    }
                }
            }
        }
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_JSON || {} );

