SHINKEN.TOOLS.TEST_AUTO_LOGGER = (function ( self ) {
    self.dom_element = [];
    self.mapping     = {};
    self.DOM         = {};
    self.TEST        = {};
    self.ACTION      = {};
    self.GET         = {};
    self.CONST       = {
        HEADER: [
            { _KEY: "status" },
            { _KEY: "timeout" },
            { _KEY: "function" },
            { _KEY: "info" }
        ]
    };
    var __do_log__   = true;
    self.init        = function () {
        self.dom_element = document.querySelector( "#id-shinken-test-auto-log" );
    };
    //********************************************  DOM ELEMENT   **************************************************//
    //********************************************  GETTER SETTER **************************************************//
    self.add = function ( timeout, function_name, info ) {
        if ( !__do_log__ ) {
            return;
        }
        if ( __is_log_mute ) {
            return;
        }
        self.dom_element.classList.remove( "shinken-hidden" );
        if ( !info ) {
            info = "";
        }
        info             = info + "";
        info             = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss( info );
        var _uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        var _data        = ['?', timeout + "", function_name, info];
        var _dom_element = DOM.Service.createElement( "tr", { class: "shinken-list-line", "data-uuid": _uuid } );
        for ( var i = 0, _size_i = _data.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-filter": self.CONST.HEADER[ i ]._KEY }, _data[ i ] ), _dom_element );
        }
        DOM.Service.addElementTo( _dom_element, self.dom_element.querySelector( "table tbody" ) );
        return _uuid;
    };
    
    self.changeElementStatus = function ( uuid, to_set, timeout ) {
        if ( !__do_log__ ) {
            return;
        }
        if ( !uuid ) {
            return;
        }
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        setTimeout( function () {
            var _element = self.dom_element.querySelector( ".shinken-list-line[data-uuid='" + uuid + "']" ).querySelector( ".shinken-list-cell[data-filter='status']" );
            if ( to_set === "OK" && SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                to_set = "NOK";
            }
            _element.innerHTML = to_set;
        }, timeout );
    };
    self.setDoLog            = function ( to_set ) {
        __do_log__ = to_set;
    };
    self.showInConsole       = function ( uuid, timeout, function_name, info ) {
        //console.log( "GSOU", "[TEST_AUTO_LOGGER - showInConsole]", self.content.getDataToExport() );
    };
    //********************************************  TEST          **************************************************//
    
    //********************************************  ACTION        **************************************************//
    self.ACTION.logToServer                           = function ( shinken_test_type, phase, status, message ) {
        SHINKEN.COMUNICATION.requestPostJSON( "http://" + SHINKEN.HIGHWAY.getHostName() + ":5000/push_test_auto_log",
            JSON.stringify( {
                session_id: 11,
                nb_test   : shinken_test_type,
                nb_phase  : phase,
                status    : status,
                message   : message,
                url       : SHINKEN.HIGHWAY.getPathWithParamsWithoutOrigin()
            } ) );
    };
    self.ACTION.logToServerProtectedFieldsDeactivated = function ( shinken_test_type, phase ) {
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.ACTION.logToServer( shinken_test_type, phase, SHINKEN.TOOLS.TEST_AUTO.CONST.STATUS.INFO, "Test non réalisé car le chiffrement n'étais pas activé" );
        SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LOGGER || {} );
