SHINKEN.TOOLS.TEST_AUTO_SOURCE_MAPPING_TAB = (function ( self ) {
    self.DOM                          = {};
    self.TEST                         = {};
    self.ACTION                       = {};
    //********************************************  DOM   **************************************************//
    self.DOM.getIFrame                = function () {
        return document.querySelector( "#tab-pane-mapping_origin_to_source-target iframe" ).contentWindow.document;
    };
    self.DOM.getBody                  = function () {
        return self.DOM.getIFrame().querySelector( 'body' );
    };
    self.DOM.helpButton               = function () {
        return self.DOM.getBody().querySelector( ".shinken-help-button-container .shinken-button" );
    };
    self.DOM.helpCloseButton          = function () {
        return self.DOM.getBody().querySelector( ".shinken-help-close-button" );
    };
    self.DOM.filterInput              = function (filter_name) {
        return self.DOM.getBody().querySelector( '.shinken-list-table .shinken-filter-line .shinken-list-filter[data-name="' + filter_name + '"] .shinken-input' );
    };
    self.DOM.filterSelect              = function (filter_name) {
        return self.DOM.getBody().querySelector( '.shinken-list-table .shinken-filter-line .shinken-list-filter[data-name="' + filter_name + '"] .shinken-list-filter-container' );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.filterStatus = function ( timeout, filter_name, state_expected ) {
        setTimeout( function () {
            var _input = self.DOM.filterInput(filter_name);
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _input, 'background-color', 'rgb(255, 255, 255)' );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _input, 'background-color', 'rgb(255, 239, 144)' );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.filterSelectStatus = function ( timeout, filter_name, state_expected ) {
        setTimeout( function () {
            var _select = self.DOM.filterSelect(filter_name).querySelector(".shinken-select-selector");
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _select, 'background-color', 'rgb(255, 255, 255)' );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _select, 'background-color', 'rgb(255, 239, 144)' );
                    break;
            }
        }, timeout );
        return 200;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnHelpButton     = function ( timeout ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnHelpButton' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.helpButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickCloseHelpButton  = function ( timeout ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickCloseHelpButton' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.helpCloseButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setInputFilter             = function ( timeout, filter_name, filter_value ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setFilter', filter_name + "=" + filter_value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.filterInput(filter_name), filter_value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setSelectFilter            = function ( timeout, filter_name, filter_value ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setFilter', filter_name + "=" + filter_value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.ACTION.clickOnOption(0, self.DOM.filterSelect(filter_name), filter_value, true)
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE_MAPPING_TAB || {} );
