SHINKEN.TOOLS.TEST_AUTO_UI_VISU_REPORT = (function ( self ) {
    self.DOM                         = {};
    self.TEST                        = {};
    self.TEST.WIDGET                 = {};
    self.TEST.JS                     = {};
    self.ACTION                      = {};
    self.CONST                       = {
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe     = function () {
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.getInput = function ( name ) {
        return self.DOM.getIframe().querySelector( 'input[name="' + name + '"]' );
    };
    self.DOM.getSubmitButton   = function () {
        return self.DOM.getIframe().getElementById( "id-shinken-button-submit" );
    };
    self.DOM.getModifySelectionButton   = function () {
        return self.DOM.getIframe().getElementById( "id-shinken-modify-selection-report" );
    };
    self.DOM.getNewSelectionButton   = function () {
        return self.DOM.getIframe().getElementById( "id-shinken-new-selection-report" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.inputValue = function ( timeout, name, value_expected ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.inputValue',  name, value_expected  );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getInput( name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom.value, value_expected, 'inputValue' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.setInputValue = function ( timeout, name, to_set ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setInputValue',  name, to_set  );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getInput( name );
            DOM.Service.setInputValue( _dom, to_set );
            SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( _dom, 'keyup' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnSubmitForm = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnSubmitForm', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getSubmitButton() );
            }
        
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnModifySelection = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnModifiySelection', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getModifySelectionButton() );
            }
        
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnNewSelection = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnModifiySelection', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getNewSelectionButton() );
            }
        
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_REPORT || {} );
