//__lib__ lib_common
'use strict';
COMPONENT.InterfaceInput           = function () {
    this.__class_name__ = 'COMPONENT.Input';
    // dom_element
    // current_value
    // original_value
    // placeholder
    // is_protected
    // is_resizable
    this.init();
};
COMPONENT.InterfaceInput.prototype = {
    init: function () {
    },
    //********************************************  SETTER GETTER   **************************************************//
    clickOnInput           : function () {
    },
    //********************************************  SETTER GETTER   **************************************************//
    hasFocus         : function () {
        return DOM.Service.hasFocus( this.dom_element_input );
    },
    getDomValue      : function () {
        return this.dom_element_input.value;
    },
    getValue         : function () {
        return this.current_value;
    },
    setValueFromJs   : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        DOM.Service.setInputValue( this.dom_element_input, to_set );
        this.validateValueInput();
        this.updateView();
        this.doExtraAction();
    },
    setValueFromInput: function () {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        if ( this.need_validation ) {
            this.updateView();
        }
        this.doExtraAction();
    },
    setStatus        : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus        : function () {
        return this.status;
    },
    setIsProtected   : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element_input.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ? "password" : "shinken-password" : this.type );
    },
    setDisabled      : function ( to_set ) {
        if ( to_set ) {
            this.dom_element_input.setAttribute( "readonly", '' );
        }
        else {
            this.dom_element_input.removeAttribute( "readonly", '' );
        }
    },
    setPlaceholder   : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || "";
        }
        to_set           = SHINKEN.TOOLS.STRING.unescape_xss( to_set );
        this.placeholder = to_set;
        if ( this.dom_element_input ) {
            this.dom_element_input.placeholder = this.placeholder;
        }
    },
    skipValidation   : function ( to_set ) {
        this.skip_validation = to_set;
    },
    hasBeenChanged   : function () {
        return this.getValue() !== this.original_value;
    },
    //********************************************  MESSAGES   **************************************************//
    setTooltip              : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip         : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip       : function ( type, text ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( text ) {
                text += "<br>";
            }
            text += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', text );
        
        text && this.hasFocus() ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setMessage              : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, this.__buildMessageForTooltip( message ) );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, this.__buildMessageForTooltip( message ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, this.__buildMessageForTooltip( message ) );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? this.__buildMessageForTooltip( message ) : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    __buildMessageForTooltip: function ( message ) {
        return message.buildMessage();
    },
    //********************************************  UPDATE VIEW  **************************************************//
    restoreCursorLocation: function ( location ) {
        this.dom_element_input.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element_input.selectionStart = this.last_cursor_location;
        this.dom_element_input.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation   : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation    : function () {
        return this.dom_element_input.selectionStart;
    },
    updateView           : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && has_inheritance ) {
            _to_write = '';
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element_input, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        if ( this.dom_element_input.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
    },
    askComputeHeight     : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element_input ) && DOM.Service.getBoundingClientRect( self.dom_element_input, 'height' ) < 150 ) {
                self.dom_element_input.style.height = Math.min( 150, self.dom_element_input.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    //********************************************  EVENT LISTENER   **************************************************//
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, self.time_out_compute_after_change );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValueFromInput();
        if ( !args ) {
            args = {};
        }
        args[ 'validation_done' ] = this.validateValueInput();
        args[ 'input_object' ]    = this;
        if ( parent ) {
            parent.doActionAfterChange( args );
        }
    },
    //********************************************  VALIDATION  **************************************************//
    validateValueInput   : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            if (this.validation_parameter){
                return this.validateValueInputNewFormat(forced, ignore_focus);
            }
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else if ( this.key_validation ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
                
            }
            else {
                return false;
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    validateValueInputNewFormat   : function () {
        if ( this.need_validation ) {
            var _to_set = COMPONENT.CONST.STATUS.NONE;
            if ( !SHINKEN_VALIDATION.Service.isValid( this.getValue(), this.validation_parameter )  ){
                _to_set = COMPONENT.CONST.STATUS.ERROR;
            }
            this.setStatus(_to_set)
            this.need_validation = false;
            return true;
        }
        return false;
    },
    addValidationRule    : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules   : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation: function () {
        if ( this.skip_validation ) {
            return;
        }
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.need_validation = true;
        }
    },
    getValidationRules   : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    setValidationParameter   : function ( validation_parameter ) {
        this.validation_parameter = validation_parameter;
    },
    //********************************************  COMPUTE  *********************************************************//
    updateUrlWithValue: function () {
        var _value = this.current_value ? this.current_value : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings          : function ( input ) {
        if ( this.current_value === input.current_value ) {
            return;
        }
        this.simulateUserInteractionWriting( input.current_value );
    },
    simulateUserInteractionWriting: function ( value ) {
        this.setValueFromJs( value );
        this.time_out_compute_after_change = 0;
        DOM.Service.SimulateAction.keyUp( this.dom_element_input );
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput, COMPONENT.Interface );


COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    this.__class_name__ = 'COMPONENT.Input';
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init: function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        
        if ( this.dom_element.classList.contains( 'shinken-input' ) || this.dom_element.classList.contains( 'shinken-input-key' ) || this.dom_element.classList.contains( 'shinken-input-search' ) ) {
            this.dom_element_input = dom_element;
        }
        else {
            this.dom_element_input = dom_element.querySelector( '.shinken-input' );
        }
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element_input.getAttribute( 'value' ) || this.dom_element_input.value;
        this.type                    = this.dom_element_input.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element_input.placeholder;
        this.placeholder             = this.placeholder_no_template;
        this.is_resizable            = this.dom_element_input.tagName === 'TEXTAREA';
        this.need_validation         = true;
        this.key_validation          = {
            "prop_name"     : parent ? parent.getParentName() : '',
            "component_name": extra_key_validation || ''
        };
        this.initInterface();
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, COMPONENT.InterfaceInput );


COMPONENT.InputFromData           = function () {
    this.__class_name__ = 'COMPONENT.InputFromData';
    this.init();
};
COMPONENT.InputFromData.prototype = {
    init: function () {
        this.current_value = "";
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element       = DOM.Service.createElement( "table", {
                class       : "shinken-input-table",
                onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
            }
        );
        var tr                 = DOM.Service.createElement( "tr" );
        var td                 = DOM.Service.createElement( "td", { class: "shinken-input-container-cell" } );
        var div                = DOM.Service.createElement( "div", { class: "shinken-input-container" } );
        var _on_change         = "MANAGER.EventManager.onChangeOnInput(event)";
        this.dom_element_input = DOM.Service.createElement( "input", {
            class      : "shinken-input",
            type       : "text",
            oncut      : _on_change,
            onpaste    : _on_change,
            onkeyup    : _on_change,
            onclick    : "MANAGER.EventManager.clickOnInput(event)",
            placeholder: this.placeholder
        } );
        
        DOM.Service.addElementTo( this.dom_element_input, div );
        DOM.Service.addElementTo( div, td );
        DOM.Service.addElementTo( td, tr );
        DOM.Service.addElementTo( tr, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromData, COMPONENT.InterfaceInput );
