'use strict';

COMPONENT.KeyValueLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    // dom_element
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.KeyValueLine.prototype = {
    initSpecific    : function () {
        this.inputs[ 'shinken-key-line' ]   = 0;
        this.inputs[ 'shinken-value-line' ] = 1;
    },
    initSpecificEnd : function () {
        this.inputs[ 'shinken-key-line' ].key_validation += "KEY_" + this.inputs[ 'shinken-key-line' ].key_validation;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue        : function () {
        if ( !this.inputs[ 'shinken-value-line' ].getValue() ) {
            this.updateCfgDomElement();
            return "";
        }
        var _to_return = this.inputs[ 'shinken-key-line' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += this.inputs[ 'shinken-value-line' ].getValue();
        this.updateCfgDomElement();
        return _to_return;
    },
    setValueFromUser: function ( value ) {
        switch ( this.getParentName() ) {
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                var _last_index = value.length - 1;
                this.setValue( value[ _last_index ] );
                value.splice( _last_index, 1 );
                this.setKey( SHINKEN.TOOLS.ARRAY.join( value, this.separator_key_value_html ) );
                break;
            default:
                console.warn("key_value_line.js", "setValueFromUser  : [note implemented for ]", this.getParentName() );
        }
    },
    setKey          : function ( to_set ) {
        this.inputs[ 'shinken-key-line' ].setValueFromJs(to_set);
    },
    setValue        : function ( to_set ) {
        this.inputs[ 'shinken-value-line' ].setValueFromJs(to_set);
    },
    getCfgValue     : function () {
        return SHINKEN.TOOLS.STRING.cleanXss(this.inputs[ 'shinken-key-line' ].getValue()) + this.separator_key_value_html + SHINKEN.TOOLS.STRING.cleanXss(this.inputs[ 'shinken-value-line' ].getValue());
    }
};

COMPONENT.getInterfaceLinePrototype( COMPONENT.KeyValueLine, 'COMPONENT.KeyValueLine' );