//__lib__ lib_common
'use strict';

SHINKEN_LIST.HeaderFromDataWithSort           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.HeaderFromDataWithSort.prototype = {
    init: function () {
        this.initSorting();
        this.initSortingAvailability();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-header-popup":
            case "click-on-option-header-popup":
            case "click-on-header":
                this.clickOnButtonSorting( event, event_name, param );
                break;
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtmlCounters: function () {
        this.dom_counter_cell        = null;
    },
    computeHtml: function () {
        this.computeHtmlSorting();
        this.computeHtmlCounters();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-header", "data-name": this.name, "data-display-sort-popup": true, "data-object-type": this.getObjectType() } ) );
        this.cell_content            = DOM.Service.createElement( "div", { class: "shinken-list-cell-content", onclick: "MANAGER.EventManager.clickOnButton(event, 'click-on-header', '" + this.name + "')" } );
        var _table                   = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-header-table" } );
        var _line                    = DOM.Service.createElement( "tr", {} );
        var _label_cell              = DOM.Service.createElement( "td", { class: "shinken-list-header-name-cell" }, "<div class='shinken-list-header-name'>" + this.label + "</div>" );
        this.dom_sort_priority_cell  = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-cell" } );
        this.dom_actions_button_cell = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-button-cell" } );
        
        
        DOM.Service.addElementTo( _label_cell, _line );
        DOM.Service.addElementTo( this.dom_counter_cell, _line );
        DOM.Service.addElementTo( this.dom_sort_priority_cell, _line );
        DOM.Service.addElementTo( this.dom_actions_button_cell, _line );
        DOM.Service.addElementTo( _line, _table );
        DOM.Service.addElementTo( _table, this.cell_content );
        DOM.Service.addElementTo( this.cell_content, this.dom_element );
        
        //TODO IL NE FAUDRAIT PAS UTILISER "sorting_object"
        DOM.Service.addElementTo( this.sorting_object.sort_priority_dom_element, this.dom_sort_priority_cell );
        DOM.Service.addElementTo( this.sorting_object.sort_popup_button, this.dom_actions_button_cell );
        DOM.Service.addElementTo( this.sorting_object.popup_sort_container, this.cell_content );
        
        this.setDomParentForSorting( this.dom_element );
    },
    hidePopup  : function () {
        this.hidePopupSorting();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromDataWithSort, SHINKEN_LIST.HeaderFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromDataWithSort, SHINKEN.OBJECT.SortingInterface );