//__lib__ lib_common
'use strict';

SHINKEN_LIST.LineCellFromHtml           = function ( dom_element, type ) {
    this.init( dom_element );
    this.type = type;
};
SHINKEN_LIST.LineCellFromHtml.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initWithDom();
    },
    initWithDom: function () {
        this.name = this.dom_element.dataset.filter;
        if ( this.dom_element.dataset.filterValueArray ) {
            this.value = this.dom_element.dataset.filterValueArray.split( "," );
        }
        else if ( this.dom_element.dataset.filterValue ) {
            this.value = this.dom_element.dataset.filterValue;
        }
        else {
            this.value = DOM.Service.getInnerText( this.dom_element );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this[ 'data_name_array' ] = this.uuid;
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID: function () {
        return this.name;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellFromHtml, SHINKEN_LIST.LineCell );

