"use strict";

SHINKEN_LIST.Pagination = function ( page_size ) {
    this.__class_name__ = "SHINKEN_LIST.Pagination";
    this.init( page_size );
};

SHINKEN_LIST.Pagination.prototype = {
    init                : function ( page_size ) {
        this.page_size          = page_size || 100;
        this.total_page         = 0;
        this.current_page_index = 0;
        this.initSpecificContents();
    },
    initSpecificContents: function ( page_size ) {
        this.initContents();
        this.add( new SHINKEN_LIST.PaginationNavigation( COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST ) );
        this.add( new SHINKEN_LIST.PaginationNavigation( COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS ) );
        this.add( new SHINKEN_LIST.PaginationSelector( this.total_page, this.current_page_index ) );
        this.add( new SHINKEN_LIST.PaginationNavigation( COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT ) );
        this.add( new SHINKEN_LIST.PaginationNavigation( COMPONENT.CONST.PAGINATION_NAVIGATION.LAST ) );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_pagination_btn":
                switch ( param ) {
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST :
                        this.setActiveIndex( 0 );
                        break;
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS :
                        this.setActiveIndex( this.current_page_index - 1 );
                        break;
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT :
                        this.setActiveIndex( this.current_page_index + 1 );
                        break;
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.LAST :
                        this.setActiveIndex( this.total_page - 1 );
                        break;
                }
                break;
            case "click_on_item_selector" :
                this.setActiveIndex( parseInt( param.getValue() ), true );
                break;
            default:
                console.warn( "[Pagination - doActionAfter]", event_name );
                break;
        }
    },
    clickOnSelector    : function ( key_name, parent ) {
        this.getSelector().clickOnSelector( key_name, parent );
    },
    clickOnItemSelector: function ( event, parent_name, element ) {
        this.getSelector().clickOnItemSelector( event, parent_name, element );
    },
    onClick            : function ( event ) {
        this.getSelector().onClick();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getSelector            : function () {
        return this.getContentByUUID( "pagination_selector" );
    },
    setActiveIndex         : function ( index, index_already_update ) {
        this.current_page_index = parseInt( index );
        if ( !index_already_update ) {
            this.getSelector().setCurrentPage( this.current_page_index );
        }
        this.computeClass();
    },
    getDisplayStartingIndex: function () {
        return this.current_page_index * this.page_size;
    },
    getDisplayEndingIndex  : function ( to_set ) {
        return this.getDisplayStartingIndex() + this.page_size;
    },
    setTotalElement        : function ( to_set ) {
        this.setActiveIndex( 0 );
        this.total_page = parseInt( Math.ceil( to_set / this.page_size ) );
        this.getSelector().setTotalPage( this.total_page );
        this.computeClass();
    },
    setPageSize            : function ( to_set ) {
        this.page_size = to_set;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml : function () {
        if ( this.getDomElement() ) {
            DOM.Service.empty( this.getDomElement() );
        }
        else {
            this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-pagination" } ) );
        }
        var _div   = DOM.Service.createElement( "div", { class: "shinken-pagination-container" } );
        var _table = DOM.Service.createElement( "table", { class: "shinken-pagination-container-table shinken-table" } );
        var _tr    = DOM.Service.createElement( "tr" );
        
        for ( var i = 0; i < this.getSize(); i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), _tr );
        }
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _div );
        this.addDomElement( _div );
        this.computeClass();
    },
    computeClass: function () {
        if ( !this.getDomElement() ) {
            return;
        }
        
        this.getDomElement().classList.remove( "shinken-is-first-pagination" );
        this.getDomElement().classList.remove( "shinken-is-last-pagination" );
        if ( this.current_page_index === 0 ) {
            this.getDomElement().classList.add( "shinken-is-first-pagination" );
        }
        if ( this.current_page_index === this.total_page - 1 || this.total_page === 0 ) {
            this.getDomElement().classList.add( "shinken-is-last-pagination" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Pagination, SHINKEN.OBJECT.ShinkenObjectContainerHtml );