//priority 10
//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.CounterV2_CONST = {
    TYPE: {
        ERRORS   : "errors",
        WARNINGS : "warnings",
        TOTAL    : "total",
        FILTERING: "filtering"
    }
};

SHINKEN.OBJECT.CounterV2           = function ( type ) {
    this.__class_name__ = 'SHINKEN.OBJECT.CounterV2';
    this.init( type );
};
SHINKEN.OBJECT.CounterV2.prototype = {
    init: function ( type ) {
        this._counter_final       = 0;
        this.label                = "";
        this._is_label_before     = false;
        this._show_if_null        = false;
        this._is_string           = false;
        this.type                 = type;
        this._show_to_parent      = true;
        this._data_target_name    = "number";
        this._counter_parent_list = [];
        this._elements_mapping    = {};
        this.uuid                 = SHINKEN.TOOLS.STRING.buildUUID();
        this._targets_dom_element = [];
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue                  : function () {
        return this._counter_final;
    },
    hasCounter                : function () {
        return !!this._counter_final;
    },
    setShowIfNull             : function ( to_set ) {
        this._show_if_null = !!to_set;
    },
    reset                     : function () {
        this._elements_mapping = {};
        this._counter_final    = 0;
        this.showForParent( true );
        this.updateTargetsDomElement();
        this._updateHTML();
    },
    showForParent             : function ( show ) {
        this._show_to_parent = !!show;
        this.updateParents();
    },
    updateParents             : function () {
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].update( this.uuid, this._show_to_parent ? this._counter_final : 0 );
        }
    },
    update                    : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this._elements_mapping[ name ];
        }
        else {
            if ( !is_force && this._elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this._elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltipHtml( tooltip );
        }
        
        this._counter_final = this._is_string ? "" : 0;
        this.askFinalUpdate( retry_update_html );
    },
    askFinalUpdate            : function ( retry_update_html ) {
        if ( this.timeout_final_update ) {
            clearTimeout( this.timeout_final_update );
        }
        var self                  = this;
        self.timeout_final_update = setTimeout( function () {
            self.finalUpdate( retry_update_html );
            self.timeout_final_update = null;
        }, 10 );
    },
    finalUpdate               : function ( retry_update_html ) {
        var _keys = Object.keys( this._elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this._counter_final = this._counter_final + this._elements_mapping[ _keys[ i ] ];
        }
        this.updateTargetsDomElement();
        this.updateParents();
        return this._askUpdateHTML( retry_update_html );
    },
    setParent                 : function ( to_add ) {
        if ( !to_add ) {
            return;
        }
        this._counter_parent_list.push( to_add );
        this.updateParents();
    },
    setDataTargetName         : function ( to_set ) {
        this._data_target_name = to_set;
    },
    doActionAfterSetDomElement: function () {
        if ( !this.dom_element_label ) {
            this.dom_element_label = this.getDomElement().querySelector( ".shinken-counter-label" );
        }
    },
    setDomElementLabel        : function ( to_set ) {
        this.dom_element_label = to_set;
        this._updateHTML();
    },
    addTargetsDomElement      : function ( to_set ) {
        this._targets_dom_element.push( to_set );
        this.updateTargetsDomElement();
    },
    updateTargetsDomElement   : function () {
        for ( var i = 0, _size_i = this._targets_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.setDataSet( this._targets_dom_element[ i ], this._data_target_name, this._counter_final || '' );
        }
    },
    setLabel                  : function ( to_set, is_before ) {
        this.label            = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this._is_label_before = !!is_before;
    },
    isString                  : function ( to_set ) {
        this._is_string = to_set;
    },
    _askUpdateHTML            : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            self.timeout_html = null;
        }, 50 );
    },
    _updateHTML               : function ( retry_update_html ) {
        if ( !this.dom_element_label && !this.dom_element ) {
            return;
        }
        var _html       = "";
        var _data_value = "";
        if ( this._counter_final ) {
            _html       = (this.label ? this._is_label_before ? this.label + this._counter_final : this._counter_final + this.label : this._counter_final);
            _data_value = this._counter_final;
        }
        else if ( this._show_if_null ) {
            _html       = "0";
            _data_value = "0";
        }
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = _html;
        }
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'number', _data_value );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterV2, SHINKEN.OBJECT.ShinkenObjectHtml );



SHINKEN.OBJECT.CounterInterfaceV2           = function () {
};
SHINKEN.OBJECT.CounterInterfaceV2.prototype = {
    initCounter          : function ( type ) {
        if ( !this.counters ) {
            this.counters = {};
        }
        this.counters[ type ] = new SHINKEN.OBJECT.CounterV2( type );
    },
    resetCounters        : function () {
        var _keys = Object.keys( this.counters );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counters[ _keys[ i ] ].reset();
        }
    },
    countersShowForParent: function ( to_set ) {
        var _keys = Object.keys( this.counters );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counters[ _keys[ i ] ].showForParent( to_set );
        }
    },
    hasCounter           : function ( type ) {
        return this.counters[ type ].hasCounter();
    },
    setCounterValue      : function ( type, data_name, nb ) {
        this.counters[ type ].update( data_name, nb );
    },
    getCounter           : function ( type ) {
        return this.counters[ type ];
    },
    setCountersParent     : function ( parent ) {
        var _keys = Object.keys( this.counters );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.setCounterParent(parent, _keys[ i ]);
        }
    },
    setCounterParent     : function ( parent, type ) {
        this.counters[ type ].setParent( parent.getCounter( type ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceV2, SHINKEN.OBJECT.ShinkenObjectHtml );
