//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.DataHistoric                = function () {
    this.init();
};
SHINKEN.OBJECT.DataHistoric.prototype      = {
    init               : function () {
        this._original = null;
        this.resetPreviews();
    },
    resetPreviews      : function () {
        this._valid_previewing = [];
        this.resetInvalidPreview();
    },
    resetInvalidPreview: function () {
        this._invalid_preview = null;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getLastValid     : function () {
        if ( this._invalid_preview ) {
            this.resetInvalidPreview();
            if ( this.hasValidPreview() ) {
                return this._valid_previewing[ this._valid_previewing.length - 1 ];
            }
            return this._original;
        }
        if ( this.hasValidPreview() ) {
            this._valid_previewing.pop();
            if ( this.hasValidPreview() ) {
                return this._valid_previewing[ this._valid_previewing.length - 1 ];
            }
        }
        return this._original;
    },
    hasValidPreview  : function () {
        return this._valid_previewing.length;
    },
    setOriginal      : function ( to_set ) {
        this._original = new SHINKEN.OBJECT.DataEntryHistoric( to_set );
    },
    getOriginal      : function () {
        return this._original;
    },
    addValidPreview  : function ( to_add ) {
        this.resetInvalidPreview();
        this._valid_previewing.push( new SHINKEN.OBJECT.DataEntryHistoric( to_add ) );
    },
    setInvalidPreview: function ( to_set ) {
        this._invalid_preview = to_set;
    }
};
SHINKEN.OBJECT.DataEntryHistoric           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DataEntryHistoric.prototype = {
    init: function ( data ) {
        this.setData( data );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getData   : function () {
        return this.data;
    },
    setData   : function ( to_set ) {
        this.data = to_set;
    },
    updateData: function ( to_add ) {
        var _keys = Object.keys( to_add );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key              = _keys[ i ];
            this.data[ _current_key ] = to_add[ _current_key ];
        }
    }
};
