//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.DefaultConfiguration           = function ( default_configuration ) {
    this.init( default_configuration );
};
SHINKEN.OBJECT.DefaultConfiguration.prototype = {
    init        : function ( default_configuration ) {
        this.initInternal();
        this.updateData( default_configuration );
    },
    initInternal: function () {
        this.children_object = [];
        this.children_dict   = {};
        this.own_property    = [];
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getValidOwnProperty        : function () {
        if ( typeof this.valid_own_property === "undefined" ) {
            this.valid_own_property = this._getValidOwnProperty();
        }
        return this.valid_own_property;
    },
    _getValidOwnProperty       : function () {
        return false;
    },
    getValidOwnChildren        : function () {
        if ( typeof this.valid_own_children === "undefined" ) {
            this.valid_own_children = this._getValidOwnChildren();
        }
        return this.valid_own_children;
    },
    _getValidOwnChildren       : function () {
        return false;
    },
    getChildrenObject          : function () {
        return this.children_object;
    },
    getChildrenObjectDict      : function () {
        return this.children_dict;
    },
    _getObjectToJson           : function () {
        //this.computeMandatoryMissingData();
        var _valid_own_property = this.getValidOwnProperty() ? this.getValidOwnProperty().getKeys() : false;
        var _to_add             = _valid_own_property || this.own_property || [];
        var to_return           = {};
        for ( var i = 0, _size_i = _to_add.length; i < _size_i; i++ ) {
            if ( typeof this[ _to_add[ i ] ] === 'undefined' ) {
                continue;
            }
            to_return[ _to_add[ i ] ] = this[ _to_add[ i ] ].getObjectToJson();
        }
        return to_return;
    },
    //computeMandatoryMissingData: function () {
    //},
    getDefaultValueLabel       : function () {
        return "default";
    },
    setUnknownValue                : function ( key, value_object ) {
        if ( !this.unknown_property ) {
            this.unknown_property = {};
        }
        this.unknown_property[ key ] = value_object instanceof SHINKEN.OBJECT.Param ? value_object : new SHINKEN.OBJECT.Param( key, value_object );
        this._setUnknownValue()
    },
    _setUnknownValue                : function ( key, value ) {
    },
    setIsNotTheExpectedObject      : function ( key, value_object ) {
        if ( !this.not_valid_format_property ) {
            this.not_valid_format_property = {};
        }
        this.not_valid_format_property[ key ]          = value_object instanceof SHINKEN.OBJECT.Param ? value_object : new SHINKEN.OBJECT.Param( key, value_object );
        this._setIsNotTheExpectedObject()
    },
    _setIsNotTheExpectedObject                : function ( key, value ) {
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData           : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData              : function ( key, value ) {
        return this._setData( key, value );
    },
    _setData             : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( typeof value === 'object' && value !== null && value !== undefined ) {
                    if ( !this._setDataDefaultObject( key, value ) ) {
                        this.setUnknownValue( key, value );
                    }
                    this.children_object.push( this[ key ] );
                    this.children_dict[ key ] = this[ key ];
                }
                else {
                    this.setValueDefault( key, value );
                }
                break;
        }
    },
    _setDataDefaultObject: function ( key, value ) {
        this[ key ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
        return true;
    },
    setValueDefault      : function ( key, value ) {
        this[ key ]               = new SHINKEN.OBJECT.Param( key, {} );
        this[ key ].user_value = value
        var _valid_own_properties = this.getValidOwnProperty();
        if ( _valid_own_properties ) {
            var _parameter = _valid_own_properties.getParameter( key );
            if ( !_parameter ) {
                var _valid_own_children_keys = this.getValidOwnChildren();
                if ( _valid_own_children_keys && SHINKEN.TOOLS.ARRAY.contains( _valid_own_children_keys.getKeys(), key ) ) {
                    this.setIsNotTheExpectedObject( key, this[ key ] );
                }
                else {
                    this.setUnknownValue( key, this[ key ] );
                }
                return;
            }
            else {
                this.changeToDefaultValueIfNeeded(key, value, _parameter);
            }
            //this.validateWith( key, _parameter );
        }
        this.own_property.push( key );
    },
    //validateWith         : function ( key, _parameter ) {
    //    this[ key ].validateWith( _parameter, this.getDefaultValueLabel() );
    //},
    changeToDefaultValueIfNeeded         : function ( key, value, parameter ) {
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.ShinkenObjectJson );


SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    _setDataDefaultObject      : function ( key, value_object ) {
        var _current = this.getValidOwnChildren().getConfigurationChild( key );
        if ( _current ) {
            if ( typeof value_object === "undefined" ) {
                this[ key ] = eval( "new " + _current.class_constructor + "({})" );
            }
            else {
                this[ key ] = eval( "new " + _current.class_constructor + "(value_object)" );
            }
            if ( _current.extra_action ) {
                eval( "this[ key ]." + _current.extra_action );
            }
            return true;
        }
        //this[ key ] = new SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty( value_object );
        return false;
    },
    _getValidOwnProperty       : function () {
        return new SHINKEN_VALIDATION.Parameters();
    },
    _getValidOwnChildren       : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren();
    },
    getChildrenObject          : function () {
        var _to_return         = [];
        var _own_children_keys = this._getValidOwnChildren().getKeys();
        var _to_add            = null;
        for ( var i = 0, _size_i = _own_children_keys.length; i < _size_i; i++ ) {
            _to_add = this.getChild( _own_children_keys[ i ] );
            if ( _to_add ) {
                _to_return.push( _to_add );
            }
        }
        return _to_return;
    },
    getChildrenObjectDict      : function () {
        var _to_return         = {};
        var _own_children_keys = this._getValidOwnChildren().getKeys();
        var _to_add            = null;
        for ( var i = 0, _size_i = _own_children_keys.length; i < _size_i; i++ ) {
            _to_add = this.getChild( _own_children_keys[ i ] );
            if ( _to_add ) {
                _to_return[ _own_children_keys[ i ] ] = _to_add;
            }
        }
        return _to_return;
    },
    getChild                   : function ( key ) {
        if ( !this[ key ] || typeof this[ key ] === 'string' ) {
            this._setDataDefaultObject( key );
        }
        return this[ key ];
    },
    getValue                   : function ( key ) {
        if ( !this[ key ] ) {
            this.setValueDefault( key );
        }
        return this[ key ].getValue();
    },
    getBooleanValue            : function ( key ) {
        return SHINKEN.TOOLS.BOOLEAN.parseToBoolean( this.getValue( key ) );
    },
    isValid                    : function ( key ) {
        if ( !this[ key ] ) {
            this.setValueDefault( key );
        }
        return !this[ key ].hasError();
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty, SHINKEN.OBJECT.DefaultConfiguration );

SHINKEN.OBJECT.DefaultConfigurationChildren           = function ( parameters ) {
    this.content = [];
    if ( parameters ) {
        this.init( parameters );
    }
};
SHINKEN.OBJECT.DefaultConfigurationChildren.prototype = {
    init                 : function ( parameters ) {
        for ( var i = 0, _size_i = parameters.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN.OBJECT.DefaultConfigurationChild( parameters[ i ] ) );
        }
    },
    getConfigurationChild: function ( key ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            if ( this.content[ i ].key === key ) {
                return this.content[ i ];
            }
        }
        return null;
    },
    getKeys              : function () {
        return SHINKEN.TOOLS.ARRAY.extractKey( this.content, 'key' );
    },
    getContent           : function () {
        return this.content;
    }
};

SHINKEN.OBJECT.DefaultConfigurationChild           = function ( args ) {
    this.key               = args[ 0 ];
    this.class_constructor = args[ 1 ];
    this.extra_action      = args[ 2 ];
};
SHINKEN.OBJECT.DefaultConfigurationChild.prototype = {};