//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.DefaultConfiguration           = function ( default_configuration ) {
    this.init( default_configuration );
};
SHINKEN.OBJECT.DefaultConfiguration.prototype = {
    init: function ( default_configuration ) {
        this.children_object = [];
        this.children_dict   = {};
        this.own_property    = [];
        this.updateData( default_configuration );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildrenObject    : function () {
        return this.children_object;
    },
    getChildrenObjectDict: function () {
        return this.children_dict;
    },
    _getObjectToJson      : function () {
        var to_return = {};
        for ( var i = 0, _size_i = this.own_property.length; i < _size_i; i++ ) {
            to_return[ this.own_property[ i ] ] = this[ this.own_property[ i ] ];
        }
        return to_return;
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( typeof value === 'object' ) {
                    this[ key ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
                    this.children_object.push( this[ key ] );
                    this.children_dict[ key ] = this[ key ];
                }
                else {
                    this[ key ] = value;
                    this.own_property.push( key );
                }
                break;
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.ShinkenObjectJson );