//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.SoundNotificationOfChange = function ( data ) {
    this.init( data );
};

SHINKEN.OBJECT.SoundNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
        this.audio = new Audio("/static/" + __SHINKEN_HTTP_START_TIME__ + "/common_ui/sounds/shinken_basic_notification.mp3");
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "ask_play_notification_of_sound":
                this.setPhaseIfNotPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "change_value_notification_of_change_sound":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED, param );
                break;
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "reset_change_detected":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "one_widget_with_change_detected":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
                break;
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getValue: function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED:
                if ( typeof value === "object" ) {
                    this[ key ] = value.value;
                }
                else {
                    this[ key ] = value;
                }
                break;
        }
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.playNotification();
                this.doActionAfter( "reset_change_detected" );
                break;
            default:
                break;
        }
    },
    playNotification: function ( ) {
        var play_promise = this.audio.play();
    },
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return                                                          = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] = this.getValue();
        return _to_return;
    },
    //**************************************    HTML         **************************************************//
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #sound-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SoundNotificationOfChange, SHINKEN.OBJECT.PhaseInterface );
