//__lib__ lib_common
'use strict';

SHINKEN.SERVER.ShinkenServers = function ( data ) {
    this.init( data );
};

SHINKEN.SERVER.ShinkenServers.prototype = {
    init: function ( data ) {
        this.size    = 0;
        this.list    = [];
        this.need_compute_html = false;
        if ( !data ) {
            return;
        }
        this.updateData( data );
    },
    //********************************************  UPDATE  *****************************************************//
    updateData: function ( datas ) {
        this.size              = datas.length;
        var _current_hash =  SHINKEN.TOOLS.STRING.hashCode( JSON.stringify( datas ) );
        if(this.hash === _current_hash) {
            return;
        }
        this.list = [];
        this.hash = _current_hash;
        this.need_compute_html = true;
        for ( var i = 0; i < this.size; i++ ) {
            this.list.push( new SHINKEN.SERVER.ShinkenServer( datas[ i ] ) );
        }
    },
    //********************************************  GETTER / SETTER  *****************************************************//
    hasServers: function () {
        return !!this.size;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        if ( this.need_compute_html ) {
            for ( var i = 0; i < this.size; i++ ) {
                this.list[ i ].computeHtml();
            }
            this.need_compute_html = false;
        }
    }
};