//__lib__ lib_common
'use strict';

SHINKEN.SlaQuality = function ( status_code, sla_status_code ) {
    this.init( status_code, sla_status_code );
};

SHINKEN.SlaQuality.prototype = {
    init                   : function ( status_code, sla_status_code ) {
        this.status_code     = status_code;
        this.sla_status_code = sla_status_code;
        if ( typeof this.status_code === "undefined" && typeof this.sla_status_code === "undefined" ) {
            this.name = SHINKEN.SLA_QUALITY.LOCK;
        }
        else {
            this.name = SHINKEN.SLA_QUALITY.MAPPING[ sla_status_code ][ status_code ];
        }
    },
    getPath                : function () {
        return "img/sla_quality/" + this.name + ".svg";
    },
    getInnerHtmlViaTemplate: function () {
        if ( this.name === SHINKEN.SLA_QUALITY.LOCK ) {
            return '<div class="shinken-user-no-right-to-see"><span class="shinkon shinkon-lock"\n' +
                   ' onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"\n' +
                   ' onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"\n' +
                   ' shi-tip-html="' + _( "widget.weather.shinken_element_user_no_right" ) + '"></span></div>';
        }
        else {
            return SHINKEN.SlaQualityService.getTemplateInnerHtml( this );
        }
    }
};


