//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.InterfaceSlidePanelVertical           = function () {
};
SHINKEN.OBJECT.InterfaceSlidePanelVertical.prototype = {
    initSize: function ( init_with_ratio ) {
        this.height_original = DOM.Service.getBoundingClientRect( this.dom_element_main_part.parentElement, DOM.CONST.STYLE.HEIGHT );
        if ( !this.height_original ) {
            var self = this;
            setTimeout( function () {
                // I HAVE TO DO THIS BECAUSE I DON4T KNOW THE HEIGHT AT THE INIT...
                self.initSize( init_with_ratio );
            }, 200 );
            return;
        }
        this.height_screen = window.innerHeight;
        DOM.Service.setStyle( this.main_structure, DOM.CONST.STYLE.HEIGHT, this.height_original );
        this.computeAfterResize( this.height_original * (init_with_ratio || 0.2) );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    onDragStop       : function () {
        this.current_height = DOM.Service.getBoundingClientRect( this.getDomElement(), DOM.CONST.STYLE.HEIGHT );
    },
    askClose         : function () {
        DOM.Service.addOrRemoveClasses( this.getDomElement(), true, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, true, "shinken-hidden" );
        this.computeAfterResize( 0 );
    },
    askOpen          : function () {
        DOM.Service.addOrRemoveClasses( this.getDomElement(), false, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, false, "shinken-hidden" );
    },
    computePinButtons: function ( current_height ) {
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.min_height === current_height, "shinken-max-height-on" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.getMaxHeight() === current_height, "shinken-min-height-on" );
    },
    doActionAfter    : function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_after_resize_done":
                this.computePinButtons( this.current_height );
                break;
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    computeAfterResize  : function ( height ) {
        if ( !this.content_html ) {
            DOM.Service.setStyle( this.dom_element_main_part, DOM.CONST.STYLE.HEIGHT, this.height_original );
            return;
        }
        if ( height > this.height_screen || height < this.min_height ) {
            height = this.min_height;
        }
        else if ( height > this.getMaxHeight() ) {
            height = this.getMaxHeight();
        }
        this.current_height = height;
        DOM.Service.setStyle( this.getDomElement(), DOM.CONST.STYLE.HEIGHT, this.current_height );
        DOM.Service.setStyle( this.dom_element_main_part, DOM.CONST.STYLE.HEIGHT, this.height_original - this.current_height - this.getHeightButtons() );
        this.doActionAfter( "compute_after_resize_done" );
    },
    computeAfterDragMove: function ( delta_y ) {
        var _new_height = this.current_height + delta_y;
        if ( _new_height < this.min_height ) {
            _new_height = this.min_height;
        }
        if ( _new_height > this.getMaxHeight() ) {
            _new_height = this.getMaxHeight();
        }
        DOM.Service.setStyle( this.getDomElement(), DOM.CONST.STYLE.HEIGHT, _new_height );
        DOM.Service.setStyle( this.dom_element_main_part, DOM.CONST.STYLE.HEIGHT, this.height_original - _new_height - this.getHeightButtons() );
        this.computePinButtons( _new_height );
    },
    computeSizes        : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        this.main_structure.classList.add( "shinken-hidden" ); //NEEDED IN ORDER TO IGNORE SIZE HARD SET.
        var _new_height          = window.innerHeight;
        var _ratio               = _new_height / this.height_screen;
        var _old_height_original = this.height_original;
        this.height_original     = DOM.Service.getBoundingClientRect( this.dom_element_parent, DOM.CONST.STYLE.HEIGHT );
        DOM.Service.setStyle( this.main_structure, DOM.CONST.STYLE.HEIGHT, this.height_original );
        if ( this.height_original ) {
            this.computeAfterResize( this.current_height * (this.height_original / _old_height_original) );
        }
        this.height_screen = _new_height;
        this.main_structure.classList.remove( "shinken-hidden" );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getHeightButtons: function () {
        return 22;
    },
    setMinHeight    : function ( to_set ) {
        this.min_height = to_set || 0;
    },
    setMaxHeight    : function ( to_set ) {
        this.max_height = to_set || this.height_original;
    },
    getMaxHeight    : function () {
        return this.max_height - this.getHeightButtons();
    },
    getCurrentRatio : function () {
        return this.current_height / this.height_original;
    },
    //********************************************  HTML  *****************************************************//
    computeButtonHtml      : function () {
        var _to_return  = DOM.Service.createElement( "div", { class: "shinken-slide-table-panel-buttons-container" } );
        var _table      = DOM.Service.createElement( "table", { class: "shinken-slide-table-panel-buttons" } );
        var _tr         = DOM.Service.createElement( "tr" );
        var _div_button = DOM.Service.createElement( "td", { class: "shinken-slide-panel-buttons" } );
        var _div_shadow = DOM.Service.createElement( "td", { class: "shinken-slide-panel-buttons-shadow" } );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-down",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_BOTTOM,
            "data-type": "slide-panel-vertical",
            value      : this.max_width
        } ), _div_button );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class                          : "shinken-slide-panel-button shinkon shinkon-resize-horizontal shinken-draggable",
            "data-drag-is-in-screen"       : true,
            "data-drag-resize-element-name": this.name,
            "data-type"                    : "slide-panel-vertical",
            onmousedown                    : "MANAGER.DragNDropManager.dragStartSingle(event)"
        } ), _div_button );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-up",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-type": "slide-panel-vertical",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_TOP
        } ), _div_button );
        DOM.Service.addElementTo( _div_shadow, _tr );
        DOM.Service.addElementTo( _div_button, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _to_return );
        return _to_return;
    },
    _computeHtml           : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            class: "shinken-slide-panel-content shinken-height-100"
        } ) );
        if ( this.content_html ) {
            this.addDomElement( this.content_html );
        }
        this.modifyStructureMainPart();
    },
    modifyStructureMainPart: function () {
        var _dom_parent     = this.dom_element_main_part.parentElement;
        this.main_structure = DOM.Service.createElement( "div", { class: "shinken-slide-panel-content-all shinken-height-100", "data-type": this.type } );
        this.td_buttons     = this.computeButtonHtml();
        DOM.Service.addElementTo( this.main_structure, _dom_parent );
    }
};

SHINKEN.OBJECT.SlidePanelTop           = function ( name, dom_element_main_part, min_height, max_height ) {
    this.init( name, dom_element_main_part, min_height, max_height );
};
SHINKEN.OBJECT.SlidePanelTop.prototype = {
    init: function ( name, dom_element_main_part, min_height, max_height ) {
        this.initCommon();
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP );
        this.setName( name );
        this.setMainPartDomElement( dom_element_main_part );
        this.setMinHeight( min_height );
        this.setMaxHeight( max_height );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    pinToTop   : function () {
        this.computeAfterResize( this.min_height );
    },
    pinToBottom: function () {
        this.computeAfterResize( (this.getMaxHeight() || this.height_original) );
    },
    //********************************************  SETTER GETTER  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this.getDomElement(), this.main_structure );
        DOM.Service.addElementTo( this.td_buttons, this.main_structure );
        DOM.Service.addElementTo( this.dom_element_main_part, this.main_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelTop, SHINKEN.OBJECT.InterfaceSlidePanelVertical );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelTop, SHINKEN.OBJECT.InterfaceSlidePanel );

SHINKEN.OBJECT.SlidePanelBottom           = function ( name, dom_element_main_part, min_height, max_height ) {
    this.init( name, dom_element_main_part, min_height, max_height );
};
SHINKEN.OBJECT.SlidePanelBottom.prototype = {
    init: function ( name, dom_element_main_part, min_height, max_height ) {
        this.initCommon();
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM );
        this.setName( name );
        this.setMainPartDomElement( dom_element_main_part );
        this.setMinHeight( min_height );
        this.setMaxHeight( max_height );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    pinToTop   : function () {
        this.computeAfterResize( (this.getMaxHeight() || this.height_original) );
    },
    pinToBottom: function () {
        this.computeAfterResize( this.min_height );
    },
    //********************************************  SETTER GETTER  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this.dom_element_main_part, this.main_structure );
        DOM.Service.addElementTo( this.td_buttons, this.main_structure );
        DOM.Service.addElementTo( this.getDomElement(), this.main_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelBottom, SHINKEN.OBJECT.InterfaceSlidePanelVertical );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelBottom, SHINKEN.OBJECT.InterfaceSlidePanel );