//__lib__ lib_common
'use strict';
SHINKEN.ELEMENT.UiUser = function ( data ) {
    this.init( data );
};

SHINKEN.ELEMENT.UiUser.prototype = {
    getDataForSelector: function () {
        return { name: this.getName(), label: this.getName() };
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getDefaultUrlFromSettings : function () {
        return this.getSettings() [ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.DEFAULT_URL ];
    },
    getDefaultView            : function () {
        return this.getDefaultUrlFromSettings() || this.getDefaultUrl();
    },
    init                      : function ( data ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] = true;
        if ( data ) {
            this.updateData( data );
        }
    },
    setDefaultUrlToCurrentView: function () {
        this.getSettings().default_url = SHINKEN.HIGHWAY.getHash();
    },
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.ELEMENT.USER.PARAM.ACL.KEY:
                break;
            case SHINKEN.ELEMENT.USER.PARAM.GROUPS:
                //this.setGroups( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME:
                this.setPrefs( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD:
                this.setSettings( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.STATUS:
                this.setStatus( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.UI:
                this.setUI( value );
                break;
            case "user_name":
            case SHINKEN.ELEMENT.USER.PARAM.USER_NAME:
                this.setName( value );
                break;
            case "user_uuid":
            case SHINKEN.ELEMENT.USER.PARAM.UUID:
                this.setUUID( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.VERSION:
                this.setVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.VERSION_FULL:
                this.setVersionFull( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY_BACKEND:
                this.setTilesFormat( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ARCHITECTURE:
                this.setServers( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES:
                this.setModules( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN:
                this.setIsAdmin( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION:
                this.setShinkenVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION_SHORT:
                this.setShinkenShortVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION:
                this.setCssVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TIME_ZONE_BACKEND:
                break;
            case SHINKEN.ELEMENT.USER.PARAM.EVENT_CONTAINER_DAY_KEEP_DATA:
            case SHINKEN.ELEMENT.USER.PARAM.EVENTS_CSV_EXPORT_LIMIT:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.EVENTS_EXPORT_MAX_RETRY:
                //this.setEventExportMaxRetry( value );
                break;
            case "backend_localtime_epoch":
                this.setLocalTime( value );
                break;
            case "configuration_id":
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.EXISTS:
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS__USERS__SOUND__VOLUME_PERCENT:
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS__USERS__VISUAL__BLINK__ENABLED:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS:
                CONTROLLER.UiVisualisation.doActionAfter("init_default_notifications_settings", value);
                break;
            
            default:
                //if ( APP_INFO.DEBUG ) {
            //console.warn( "[SHINKEN.ELEMENT.USER]", "[IGNORED DATA]", key, value );
            //}
        }
    },
    setPrefs: function ( value ) {
        this.getPrefs().updateData( value );
    },
    setPref : function ( key, value ) {
        this.getPrefs().setData( key, value );
    },
    setSettings            : function ( value ) {
        var _keys        = Object.keys( value );
        var _size_object = _keys.length;
        for ( var i = 0; i < _size_object; i++ ) {
            this.getSettings()[ _keys[ i ] ] = value[ _keys[ i ] ];
        }
    },
    setStatus              : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.STATUS ] = value;
    },
    setUI                  : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.UI ] = value;
    },
    getName                : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ];
    },
    getUUID                : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.UUID ];
    },
    setUUID                : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.UUID ] = value || "";
    },
    setName                : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] = value || "";
    },
    setVersion             : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] = value;
    },
    setVersionFull         : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.VERSION_FULL ] = value;
    },
    setTilesFormat         : function ( value ) {
        switch ( value ) {
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                this[ SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY ] = SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.TYPE.DEFAULT;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                this[ SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY ] = SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.TYPE.CONTEXT_UP;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                this[ SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY ] = SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.TYPE.STATUS_UP;
                break;
            default:
                if ( APP_INFO.DEBUG ) {
                    console.warn( "tiles_background unknown", "[" + value + "]", "Default value used" );
                }
                break;
        }
    },
    getDefaultUrl          : function () {
        return "#/hive/" + this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.UUID ];
    },
    getNameDefaultView     : function () {
        return this.getSettings()[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.NAME_DEFAULT_VIEW ];
    },
    _validateData          : function () {
        if ( !this.getSettings()[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.DEFAULT_URL ] && this.getPrefs().defaultScreen.uuid ) {
            var _settings                                                = {};
            _settings[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.DEFAULT_URL ] = LocationService.getUrlHiveDefaultView( this.getPrefs().defaultScreen.uuid );
            this.setSettings( _settings );
        }
    },
    clean                  : function () {
        return Http.query( {
            path  : COMMUNICATION.QUERY.GET.SHINKEN.ELEMENT.USER.KEY + '/' + this.uuid + '/clean',
            method: 'DELETE'
        } );
    },
    doesExists             : function () {
        var _to_return = $q.defer();
        this.get().then(
            function success () {
                _to_return.resolve( true );
            },
            function error ( response ) {
                switch ( response.status ) {
                    case NETWORK.HTTP_CODE._404_NOT_FOUND:
                        _to_return.resolve( false );
                        break;
                    default:
                        RefreshService.askChangeStatus( REFRESH.STATUS.BACKEND_CALL_FAILED );
                        _to_return.reject( response );
                        break;
                }
            }
        );
        return _to_return.promise;
    },
    getUserSaveData        : function getUserSaveData () {
        var OLD_USER_SAVE_PATH = 'usersave/';
        var defer              = $q.defer();
        Http.query( {
            method: 'GET',
            path  : OLD_USER_SAVE_PATH
        } ).then(
            function success ( response ) {
                defer.resolve( response.data );
            },
            function error ( response ) {
                response.status === 404 ? defer.resolve( null ) : defer.reject( response );
            }
        );
        return defer.promise;
    },
    checkMigrationNeeded   : function () {
        var to_return = $q.defer();
        var _self     = this;
        this.getUserSaveData().then( function ( data ) {
            if ( data && data[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] === MIGRATION.VERSION.V02_03_03_U1 && !_self[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] ) {
                to_return.resolve( MIGRATION.VERSION.V02_03_03_U1 );
            }
            else if ( data && _self[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] ) {
                to_return.resolve( MIGRATION.VERSION.V02_04_00_with_U1_data_to_clean );
            }
            else {
                to_return.resolve( false );
            }
            
        } );
        return to_return.promise;
    },
    isOwner                : function isOwnerUserFn ( item ) {
        return this.uuid === item.owner.uuid;
    },
    setIsAdmin             : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ]                 = to_set;
        this[ SHINKEN.ELEMENT.USER.PARAM.CAN_EDIT_WEATHER_SERVICE ] = !!this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ];
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION_TOOLTIP ]  = this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ] ? this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] : '';
    },
    setShinkenShortVersion : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION_SHORT ] = to_set;
    },
    setShinkenVersion      : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] = to_set;
    },
    setCssVersion          : function ( to_set ) {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION ] && this[ SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION ] !== to_set ) {
            ScreenService.askReloadPageNewShinkenVersion().then(
                function success () {
                    LocationService.reloadPage();
                }
            );
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION ] = to_set;
    },
    setLocalTime           : function ( to_set ) {
        //do nothing ==> will be used for heritage in SHINKEN.ELEMENT.UiCurrentUser
    },
    isAdmin                : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ];
    },
    setServers             : function ( data ) {
        if ( this.servers === undefined ) {
            this.servers = new SHINKEN.SERVER.ShinkenServers();
        }
        this.servers.updateData( data );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_ARCHITECTURE_MODULE ] = !!this.servers.size;
        CONTROLLER.NavigationBar.askUpdateArchitectureExportMenu( this.servers );
    },
    setModules             : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES ]              = to_set;
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ]       = SHINKEN.TOOLS.ARRAY.contains( to_set, 'event_container' );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] = SHINKEN.TOOLS.ARRAY.contains( to_set, 'webui_module_service_weather' );
    },
    hasServiceWeatherModule: function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] || false;
    },
    hasEventTubModule      : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ] || false;
    },
    getSettings                  : function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ] ) {
            this[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ] = {};
        }
        return this[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ];
    },
    getPrefs                     : function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ] ) {
            this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ] = new SHINKEN.ELEMENT.UiUserPrefs();
        }
        return this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ];
    },
    getPref                      : function ( pref_name ) {
        return this.getPrefs()[ pref_name ];
    },
    getDetailGraphHostWidth      : function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH ];
    },
    setShowHistoricOutputs       : function ( to_set ) {
        this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SHOW_OUTPUTS ] = to_set;
    },
    getShowHistoricOutputs       : function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SHOW_OUTPUTS ];
    },
    setCollapseAllHistoricOutputs: function ( to_set ) {
        this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.COLLAPSE_ALL_OUTPUT ] = to_set;
    },
    getCollapseAllHistoricOutputs: function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.COLLAPSE_ALL_OUTPUT ];
    },
    getSizeSlaColumn             : function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SIZE_SLA_COLUMNN ];
    },
    getDataToSave                : function () {
        var toReturn                                          = {};
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.UUID ]           = this[ SHINKEN.ELEMENT.USER.PARAM.UUID ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ]      = this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] || localStorageService.get( 'shinken-ui-user' );
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.VERSION ]        = this[ SHINKEN.ELEMENT.USER.PARAM.VERSION ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.VERSION_FULL ]   = APP_INFO.VERSION_FULL;
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ]     = this.getPrefs().getDataToSave();
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.STATUS ]         = this[ SHINKEN.ELEMENT.USER.PARAM.STATUS ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.UI ]             = this[ SHINKEN.ELEMENT.USER.PARAM.UI ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ] = this.getSettings();
        delete toReturn[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SIZE_SLA_COLUMNN ];
        return toReturn;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getLabel: function ( default_label_if_no_name ) {
        if ( !this.getName() ) {
            if ( default_label_if_no_name ) {
                return "<div class='shinken-label'>" + default_label_if_no_name + "</div>";
            }
            return "";
        }
        var _class     = this[ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] ? "shinken-label" : "shinken-label shinken-user-removed";
        var _user_name = SHINKEN.TOOLS.STRING.cleanXss( this.getName() );
        var _attribute = this[ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] ? "" : 'onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="' + _( 'users.errors.user_doesnt_exist', [DICTIONARY_COMMON_UI] ) + '"';
        return '<div class="' + _class + '" ' + _attribute + '>' + _user_name + '</div>';
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUser, SHINKEN.OBJECT.ShinkenObject );

