//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.View           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.View.prototype = {
    init      : function ( data ) {
        this.shares_uuid                              = [];
        this[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = 0;
        this[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = 0;
        if ( data ) {
            this.updateData( data );
        }
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.PARAM.NAME:
                this.setName( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.UUID:
                this.setUUID( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS._KEY:
                this.updateUsers( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.EXTERNAL_LINKS:
                this.setExternalLinks( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.NOTIFICATIONS:
            case SHINKEN.OBJECT.VIEW.PARAM.TYPE:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS:
                this [ key ] = value;
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.VIEW]", "[IGNORED DATA]", key, value );
                break;
        }
    },
    //addShareInfo: function ( key, value ) {
    //    switch ( key ) {
    //        case SHINKEN.OBJECT.SHARE.PARAM.UUID:
    //            this.shares_uuid.push( value );
    //            break;
    //        default:
    //            //this[ key ] = value;
    //            break;
    //    }
    //},
    updateUsers: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.addUserInfo( _currentKey, data[ _currentKey ] );
        }
    },
    addUserInfo: function ( key, value ) {
        
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.OWNER:
                this.setOwner( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.PREVIOUS_OWNER:
                this.setPreviousOwner( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.CREATOR:
                this.setCreator( value );
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.VIEW]", "[IGNORED USER DATA]", key, value );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setName            : function ( to_set ) {
        this[ SHINKEN.OBJECT.VIEW.PARAM.NAME ] = to_set;
    },
    setUUID            : function ( to_set ) {
        this[ SHINKEN.OBJECT.VIEW.PARAM.UUID ] = to_set;
    },
    getUUID            : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.UUID ];
    },
    getScreenType      : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.TYPE ];
    },
    getName            : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NAME ];
    },
    getShareNumber     : function () {
        return 0;
    },
    getNumberOfErrors  : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ];
    },
    getNumberOfWarnings: function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ];
    },
    getOwner           : function () {
        return this.owner_user;
    },
    getProblems        : function () {
        var _problems                                      = {};
        _problems[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = this.getNumberOfErrors();
        _problems[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = this.getNumberOfWarnings();
        return _problems;
    },
    setOwner           : function ( value ) {
        this.owner_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    getPreviousOwner   : function () {
        return this.previous_owner_user;
    },
    setPreviousOwner   : function ( value ) {
        this.previous_owner_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    getCreator         : function () {
        return this.creator_user;
    },
    setCreator         : function ( value ) {
        this.creator_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    setExternalLinks   : function ( value ) {
        this.external_links = new WEATHER.ExternalLinks( value );
    },
    getNotifications         : function () {
        return this.notifications;
    },
    setNotifications         : function ( value ) {
        this.notifications = new WEATHER.Notifications( value );
    },
};