//__lib__ lib_common
'use strict';

SHINKEN_GRID.Cells           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cells.prototype = {
    init: function ( data ) {
        this.initContents();
        if ( data ) {
            this.initData( data );
        }
    },
    //********************************************  EVENT LISTENER  *********************************************//
    onScroll: function ( event, shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).onScroll( event, shinken_grid );
        }
    },
    //********************************************  JSON  *****************************************************//
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    //********************************************  OTHERS  *****************************************************//
    getMaxTileInHeight: function () {
        var _box_content;
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return = Math.max(this.getContent(i).getValue(SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y)+this.getContent(i).getValue(SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT), _to_return);
        }
        return _to_return;
    },
    //********************************************  COMPUTE  *****************************************************//
    computeSizes: function ( shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes( shinken_grid );
        }
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    computeHtml: function ( shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.getContent( i ).computeHtml( shinken_grid ) );
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    setListContent: function ( list_content ) {
        for ( var i = 0, _size_i = list_content.length; i < _size_i; i++ ) {
            this.addCell( list_content[ i ], i );
        }
    },
    addCell       : function ( data, index ) {
        var _to_return = new SHINKEN_GRID.Cell( data );
        this.add( _to_return );
        return _to_return;
    },
    doActionAfter : function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-shinken-cell-grid":
                var _cell = this.getContentByUUID( param );
                if ( !_cell || _cell.isVisible() ) {
                    return;
                }
                var _box                            = _cell.getDisplayBox();
                this.dom_scrolling_parent.scrollTop = _box[ DOM.CONST.STYLE.TOP ];
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.ShinkenObjectContainer );