//__lib__ lib_common
'use strict';

SHINKEN_GRID.Grids           = function () {
};
SHINKEN_GRID.Grids.prototype = {
    init: function ( data ) {
        this.initContents();
        if ( data ) {
            this._initGrid( data );
        }
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    onMouseMove : function ( event ) {
        // The code is in the file weather-grids.j. It is used for cell hovering.
    },
    onMouseLeave: function ( event ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).onMouseLeave( event );
        }
    },
    onScroll    : function ( event ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).onScroll( event );
        }
    },
    mouseWheel  : function ( event ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).mouseWheel( event );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    hasGrid              : function () {
        return this.getSize() > 0;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    getGridByUUID        : function ( grid_uuid ) {
        return this.getContentByUUID(grid_uuid)
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    setPhaseForAllGrids: function ( to_set, dom_element_parent ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( dom_element_parent ){
                DOM.Service.addElementTo( this.getDomElement(), dom_element_parent );
                this.getContent(i).dom_element_parent_for_compute = this.getDomElement();
            }
            this.getContent(i).setPhase( to_set );
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    _computeMapping: function () {
        this.mapping_uuid_content = {};
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeMapping( this.mapping_uuid_content );
        }
    },
    computeSizes   : function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes();
        }
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    getDomElement: function ( dom_parent ) {
        if ( !this.dom_element ){
            this.dom_element = DOM.Service.createElement( "div", { class: "shinken-grids" } );
        }
        return this.dom_element
    },
    //********************************************  UPDATE DATA   **************************************************//
    reset            : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    _initGrid        : function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.add( new SHINKEN_GRID.Grid( data[ i ] ) );
        }
    },
    updateContentData: function ( data ) {
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            this.getContent( i ).updateContentData( data )
        }
    },
    doActionAfter              : function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-shinken-cell-grid":
            case "focus-on-shinken-cell-grid-from-cell":
                for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[i].doActionAfter(event_name, param)
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.ShinkenObjectContainer );