//__lib__ lib_common
'use strict';
SHINKEN_VALIDATION.Parameters           = function ( parameters ) {
    this.content = [];
    if ( parameters ) {
        this.init( parameters );
    }
};
SHINKEN_VALIDATION.Parameters.prototype = {
    init        : function ( parameters ) {
        for ( var i = 0, _size_i = parameters.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN_VALIDATION.Parameter( parameters[ i ] ) );
        }
    },
    getParameter: function ( key ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            if ( this.content[ i ].key === key ) {
                return this.content[ i ];
            }
        }
        return null;
    },
    getKeys     : function () {
        return SHINKEN.TOOLS.ARRAY.extractKey( this.content, 'key' );
    },
    getContent  : function () {
        return this.content;
    }
};

SHINKEN_VALIDATION.Parameter           = function ( args ) {
    this.key              = args[ 0 ];
    this.validation_type  = args[ 1 ];
    this.validation_value = args[ 2 ];
    this.is_mandatory     = args[ 3 ];
};
SHINKEN_VALIDATION.Parameter.prototype = {};
