#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING, cast
from shinken.toolbox.pickledb import ShinkenSecurityUnpicklingError
from shinkensolutions.data_hub.data_hub import DataHubConfig
from shinkensolutions.data_hub.data_hub_driver.data_hub_driver_cPickle import DataHubDriverPickle, DataHubDriverConfigPickle
from shinkensolutions.data_hub.data_hub_factory.data_hub_factory import DataHubFactory
from shinkensolutions.data_hub.data_hub_utils.data_hub_unpickler import DataHubUnpickler

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver import AbstractDataHubDriverConfig


class DataHubDriverConfigDataHubConfigFile(DataHubDriverConfigPickle):
    def __init__(self, base_directory, namespace=u'', data_location_name=u'', daemon_name=u'', module_name=u'', submodule_name=u'', file_prefix=u'shinken_'):
        # type: ( unicode, unicode, unicode, unicode, unicode, unicode, unicode ) -> None
        super(DataHubDriverConfigDataHubConfigFile, self).__init__(
            namespace=namespace,
            base_directory=base_directory,
            data_location_name=data_location_name,
            daemon_name=daemon_name,
            module_name=module_name,
            submodule_name=submodule_name,
            file_prefix=file_prefix,
        )
        # Force override
        self.name = u'CONFIG_FILE_PICKLE'
        self.file_ext = u'pickle'


def data_hub_driver_data_hub_config_file_factory(logger, driver_config, _data_hub_config):
    # type: (PartLogger, AbstractDataHubDriverConfig, DataHubConfig) -> DataHubDriverDataHubConfigFile
    return DataHubDriverDataHubConfigFile(logger, cast(DataHubDriverConfigDataHubConfigFile, driver_config))


DataHubFactory.register_driver_factory(DataHubDriverConfigDataHubConfigFile, data_hub_driver_data_hub_config_file_factory)


class DataHubDriverDataHubConfigFile(DataHubDriverPickle):
    
    def __init__(self, logger, driver_config):
        # type: (PartLogger, DataHubDriverConfigDataHubConfigFile)-> None
        super(DataHubDriverDataHubConfigFile, self).__init__(logger, driver_config)
    
    
    def _pickle_data(self, data):  # type: (DataHubConfig) -> str
        if not isinstance(data, DataHubConfig):
            raise TypeError(u'Expected a DataHubConfig object, got [ %s ]' % data)
        return super(DataHubDriverDataHubConfigFile, self)._pickle_data(data)
    
    
    def _unpickle_data(self, serialized_data):
        # type: (str) -> DataHubConfig
        obj = DataHubUnpickler.loads(serialized_data)
        if not isinstance(obj, DataHubConfig):
            raise ShinkenSecurityUnpicklingError(u'Expected a DataHubConfig object, got [ %s ]' % obj)
        return obj
