#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.


class DataHubException(Exception):
    def __init__(self, message):
        self.message = message
    
    
    def __str__(self):
        return self.message


class DataHubNotReady(DataHubException):
    def __init__(self, message=u'Data Hub not ready'):
        super(DataHubNotReady, self).__init__(message)


class DataHubItemNotFound(DataHubException):
    def __init__(self, data_type=u'', data_id=u'', message=u''):
        if not message:
            message = u'The %s [%s] was not found in Data Hub' % (data_type, data_id)
        super(DataHubItemNotFound, self).__init__(message)


class DataHubCorruptedData(DataHubException):
    def __init__(self, message=u'Corrupted data'):
        super(DataHubCorruptedData, self).__init__(message)


class DataHubFatalException(DataHubException):
    def __init__(self, message=u'Fatal exception'):
        super(DataHubFatalException, self).__init__(message)
