#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.log import PART_INITIALISATION, LoggerFactory
from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.lib_modules.configuration_reader_mixin import SeparatorFormat, ConfigurationFormat, TypeConfiguration, ConfigurationReaderMixin

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinken.objects.module import Module as ShinkenModuleDefinition
    from shinken.misc.type_hint import Optional


class MongoConf(ConfigurationReaderMixin):
    def __init__(self, _conf, logger=None, default_database=u'shinken', prefix_module_property=u''):
        # type: (ShinkenModuleDefinition, PartLogger, unicode, unicode) -> None
        self.name_database = None  # type: Optional[unicode]
        self.uri = None  # type: Optional[unicode]
        self.replica_set = None  # type: Optional[unicode]
        self.ssh_keyfile = None  # type: Optional[unicode]
        self.ssh_user = None  # type: Optional[unicode]
        self.use_ssh_retry_failure = None  # type: Optional[bool]
        self.ssh_tunnel_timeout = None  # type: Optional[int]
        self.use_ssh_tunnel = None  # type: Optional[bool]
        self.auto_reconnect_max_try = None  # type: Optional[int]
        self.auto_reconnect_sleep_between_try = None  # type: Optional[int]
        if prefix_module_property:
            prefix_module_property = u'%s__' % prefix_module_property

        if logger:
            self.logger = logger  # type: PartLogger
        else:
            self.logger = LoggerFactory.get_logger()  # type: PartLogger

        self.logger_init = self.logger.get_sub_part(PART_INITIALISATION).get_sub_part(u'MONGO')  # type: PartLogger

        configuration_format = [
            SeparatorFormat(u'MongoDB parameters'),
            ConfigurationFormat([u'database', u'name_database', u'mongodb_database', u'%sdatabase__name' % prefix_module_property], default_database, TypeConfiguration.STRING, u'name_database'),
            ConfigurationFormat([u'uri', u'mongodb_uri', u'%sdatabase__uri' % prefix_module_property], u'mongodb://localhost/?w=1&fsync=false', TypeConfiguration.STRING, u'uri'),
            ConfigurationFormat([u'replica_set', u'mongodb_replica_set', u'%sdatabase__replica_set' % prefix_module_property], u'', TypeConfiguration.STRING, u'replica_set'),
            ConfigurationFormat([u'use_ssh_tunnel', u'mongodb_use_ssh_tunnel', u'%suse_ssh_tunnel' % prefix_module_property, u'%sdatabase__use_ssh_tunnel' % prefix_module_property], 0, TypeConfiguration.INT, u'use_ssh_tunnel'),
            ConfigurationFormat([u'use_ssh_retry_failure', u'mongodb_use_ssh_retry_failure', u'%suse_ssh_retry_failure' % prefix_module_property, u'%sdatabase__use_ssh_retry_failure' % prefix_module_property], 1, TypeConfiguration.INT, u'use_ssh_retry_failure'),
            ConfigurationFormat([u'ssh_user', u'mongodb_ssh_user', u'%sssh_user' % prefix_module_property, u'%sdatabase__ssh_user' % prefix_module_property], u'shinken', TypeConfiguration.STRING, u'ssh_user'),
            ConfigurationFormat([u'ssh_keyfile', u'mongodb_ssh_keyfile', u'%sssh_keyfile' % prefix_module_property, u'%sdatabase__ssh_keyfile' % prefix_module_property], u'~shinken/.ssh/id_rsa', TypeConfiguration.STRING, u'ssh_keyfile'),
            ConfigurationFormat([u'ssh_tunnel_timeout', u'mongodb_ssh_tunnel_timeout', u'mongodb_retry_timeout', u'%sssh_tunnel_timeout' % prefix_module_property, u'%sdatabase__ssh_tunnel_timeout' % prefix_module_property], 10, TypeConfiguration.INT, u'ssh_tunnel_timeout'),
    
            SeparatorFormat(u'AutoReconnect Management'),
            ConfigurationFormat([u'auto_reconnect_max_try', u'mongodb_auto_reconnect_max_try', u'%sdatabase__retry_connection_X_times_before_considering_an_error' % prefix_module_property], 5, TypeConfiguration.INT, u'auto_reconnect_max_try'),
            ConfigurationFormat([u'auto_reconnect_sleep_between_try', u'mongodb_auto_reconnect_sleep_between_try', u'%sdatabase__wait_X_seconds_before_reconnect' % prefix_module_property], 5, TypeConfiguration.INT,
                                u'auto_reconnect_sleep_between_try'),

        ]
        ConfigurationReaderMixin.__init__(self, configuration_format, _conf, self.logger_init)
        self.read_configuration()
