#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
import re

class NEWLINE(object):
    UNIX = u'\n'
    HTML = u'<BR>'


XSS_SAFE = {
    u'<': '&lt;',
    u'>': '&gt;',
    u'"': '&quot;',
    u"'": '&apos;',
    u'/': '&#x2F;',
    # u'″': '&#8243;',
    # u'′': '&#8242;'
}


class ToolsBoxString(object):
    @staticmethod
    def format_for_message(string, separator=u', ', last_separator=u'or'):
        # type: (unicode, unicode, unicode) -> unicode
        _to_return = u'%s %s %s' % (separator.join(string[:-1]), last_separator, string[len(string) - 1],)
        return _to_return
    
    
    @staticmethod
    def escape_XSS(value):
        if not isinstance(value, basestring):
            return value
        # Deactivated because of SEF-3389 and SEF-3394
        # value = value.replace('&', '&amp;')
        for k, v in XSS_SAFE.iteritems():
            value = value.replace(k, v)
        return value
    
    
    @staticmethod
    def unescape_XSS(value):
        if not isinstance(value, basestring):
            return value
        for k, v in XSS_SAFE.iteritems():
            value = value.replace(v, k)
        return value
    
    
    @staticmethod
    def convert_newlines_to_html_line_break(value):
        # type: (unicode) -> unicode
        return value.replace(NEWLINE.UNIX, NEWLINE.HTML)
    
    
    @staticmethod
    def atoi(text):
        return int(text) if text.isdigit() else text.lower()
    
    
    @staticmethod
    def natural_keys(text):
        # sorts in human order
        # http://nedbatchelder.com/blog/200712/human_sorting.html
        return [ToolsBoxString.atoi(c) for c in re.split(r'(\d+)', text)]
