#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceServiceHostTemplate(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'hostgroup_name',
        'active_checks_enabled',
        'business_impact_modulations',
        'check_running_timeout',
        'duplicate_foreach',
        'obsess_over_service',
        'reactionner_tag',
        'notes_url',
        'escalations',
        'low_flap_threshold',
        'process_perf_data',
        'view_contacts',
        'check_period',
        'maintenance_period',
        'use',
        'notes_multi_url',
        'uuid',
        'notification_interval',
        'contacts',
        'notification_period',
        'flap_detection_options',
        'resultmodulations',
        'view_contact_groups',
        'warning_threshold_cpu_usage',
        'event_handler_enabled',
        'host_dependency_enabled',
        'service_description',
        'service_dependencies',
        'first_notification_delay',
        'flap_detection_enabled',
        'notification_options',
        'host_name',
        'default_value',
        'edition_contacts',
        'bp_rule',
        'definition_order',
        'high_flap_threshold',
        'notification_contact_groups',
        'macromodulations',
        'notifications_enabled',
        'event_handler',
        'contact_groups',
        'merge_host_contacts',
        'freshness_threshold',
        'display_name',
        'sla_critical_threshold',
        'max_check_attempts',
        'imported_from',
        'name',
        'time_to_orphanage',
        'is_cluster',
        'edition_contact_groups',
        'notification_contacts',
        'check_command',
        'checkmodulations',
        'retry_interval',
        'poller_tag',
        'servicegroups',
        'passive_checks_enabled',
        'check_interval',
        'business_impact',
        'is_volatile',
        'sla_warning_threshold',
        'from_template',
        'check_freshness'
    ]
    
    
    def __init__(self):
        super(SourceServiceHostTemplate, self).__init__()
        self.item_type = ITEM_TYPE.SERVICESHOSTTPLS
