SHINKEN.TOOLS.TEST_AUTO_UI_CONFIGURATION_MENU = (function ( self ) {
    self.DOM    = {};
    self.TEST   = {};
    self.ACTION = {};
    self.CONST  = {
        ZONE: {
            WORKING_AREA: "WORKING AREA",
            STAGING     : "STAGING",
            PRODUCTION  : "PRODUCTION"
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//

    self.DOM.menu = function (window) {
        var _document = window ? window.document : document;
        return _document.querySelector( ".shinken-menu-top-bar" );
    };
    
    self.DOM.getButtonByType        = function ( type ) {
        switch ( type ) {
            case self.CONST.ZONE.PRODUCTION :
                return self.DOM.btnProduction();
        }
    };
    self.DOM.getCounterButtonByType = function ( type ) {
        switch ( type ) {
            case self.CONST.ZONE.PRODUCTION :
                return [
                    null,
                    null,
                    null,
                    self.DOM.btnProductionCounter(),
                    null
                ];
        }
    };
    
    self.DOM.btnProduction        = function (window) {
        return self.DOM.menu(window).querySelector( "#btn-menu-apply-changes" );
    };
    self.DOM.btnProductionCounter = function () {
        return self.DOM.btnProduction().querySelector( "#id-shinken-apply-counter" );
    };
    self.DOM.logoCell             = function () {
        return self.DOM.menu().querySelector( ".shinken-logo-cell" );
    };
    self.DOM.logoVersion          = function () {
        return self.DOM.logoCell().querySelector( ".shinken-version-number" );
    };
    self.DOM.getErrorPill         = function () {
        return self.DOM.getLeftColumn().querySelector( "#id-shinken-set-apply-msg-error" );
    };
    self.DOM.getWarningPill       = function () {
        return self.DOM.getLeftColumn().querySelector( "#id-shinken-set-apply-msg-warning" );
    };
    
    //********************************************   TEST    **************************************************//
    self.TEST.menuCounter = function ( timeout, type, nb_error, nb_warning, nb_total, nb_user ) {
        setTimeout( function () {
            var counter_dom = self.DOM.getCounterButtonByType( type );
            if ( nb_error !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, counter_dom[ 1 ], nb_error );
            }
            if ( nb_warning !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, counter_dom[ 2 ], nb_warning );
            }
            if ( nb_total !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, counter_dom[ 3 ], nb_total );
            }
            if ( nb_user !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, counter_dom[ 4 ], nb_user );
            }
        }, timeout );
        return 100;
    };
    
    //********************************************  ACTION   **************************************************//
    //self.ACTION.toggleShowConfiguration     = function ( timeout ) {
    //    var _to_return = 400;
    //    var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.toggleShowConfiguration' );
    //    setTimeout( function () {
    //        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
    //        SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.showConfigurationButton() );
    //        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
    //    }, timeout );
    //    return _to_return;
    //};
    //
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_CONFIGURATION_MENU || {} );
