SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LIST_ALL = (function ( self ) {
    self.DOM                                = {};
    self.TEST                               = {};
    self.ACTION                             = {};
    self.CONST                              = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                      = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.header                         = function () {
        return self.DOM.getIframe().querySelector( "#id-shinken-title-list-all" );
    };
    self.DOM.buttonAutoRefresh              = function () {
        return self.DOM.header().querySelector( ".actionButtons .auto-refresh-btn" );
    };
    self.DOM.buttonRefreshManual            = function () {
        return self.DOM.header().querySelector( ".shinken-view-button-refresh .shinken-icon-refresh-cell" );
    };
    self.DOM.buttonExportCSV                = function () {
        return self.DOM.header().querySelector( ".shinken-view-button-export-csv" );
    };
    self.DOM.exportCSVFrame                 = function () {
        return self.DOM.getIframe().querySelector( ".loading-frame" );
    };
    self.DOM.exportSaveButton               = function () {
        return self.DOM.header().querySelector( ".save-list-btn" );
    };
    self.DOM.inputName                      = function () {
        return self.DOM.header().querySelector( "#inputListAllName" );
    };
    self.DOM.lineFilter                     = function ( index_line_filter ) {
        index_line_filter = index_line_filter || 0;
        return self.DOM.getIframe().querySelectorAll( ".row-filter-header" )[ index_line_filter ];
    };
    self.DOM.filter                         = function ( filter_name, index_line_filter ) {
        index_line_filter = index_line_filter || 0;
        return self.DOM.getIframe().querySelector( "th.filter-cell[data-uuid='1_" + filter_name + "_" + index_line_filter + "']" );
    };
    self.DOM.getOptionFilter                = function ( filter_name, option_name, index_line_filter ) {
        var _doms = self.DOM.filter( filter_name, index_line_filter ).querySelectorAll( ".optionFilter" );
        for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
            if ( _doms[ i ].innerText.trim() === option_name ) {
                return _doms[ i ];
            }
        }
        return null;
    };
    self.DOM.columnHeader                   = function ( column_name ) {
        return self.DOM.getIframe().getElementById( "header_" + column_name );
    };
    self.DOM.columnHeaderLabel              = function ( column_name ) {
        return self.DOM.columnHeader( column_name ).querySelector( ".header-shinken-grid-name" );
    };
    self.DOM.headerManager                  = function () {
        return self.DOM.getIframe().querySelector( ".shinken-grid-header-manager" );
    };
    self.DOM.headerManagerSubMenu           = function () {
        return self.DOM.headerManager().querySelector( ".shinken-grid-header-manager-sub-menu" );
    };
    self.DOM.headerManagerSubMenuList       = function () {
        return self.DOM.headerManagerSubMenu().querySelector( ".shinken-grid-header-manager-sub-menu-list" );
    };
    self.DOM.headerManagerSubMenuListColumn = function ( column_name ) {
        return self.DOM.headerManagerSubMenuList().querySelector( ".shinkenGridHeaderManagerSubMenuElement[data-header-id='header_" + column_name + "']" );
    };
    //********************************************  GETTER   **************************************************//
    //********************************************  TEST   **************************************************//
    self.TEST.displayCSVExportFrame               = function ( timeout ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayCSVExportFrame', "" );
        
        setTimeout( function () {
            var csvFrame = self.DOM.exportCSVFrame();
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, csvFrame );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, 10000 );
        
        return _to_return;
    };
    self.TEST.isOptionFilterState                 = function ( timeout, state, filter_name, option_name, index_line_filter ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAutoRefresh', filter_name + "-" + option_name + "-" + index_line_filter );
        setTimeout( function () {
            var _option_dom = self.DOM.getOptionFilter( filter_name, option_name, index_line_filter );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_SELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.exists( 0, _option_dom, option_name );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_UNSELECTABLE:
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "0.18", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "pointer-events", "none", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.NOT_SELECTED_SELECTABLE:
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgba(0, 0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(0, 0, 0)", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.UNKNOWN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _option_dom, option_name );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgba(0, 0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(0, 0, 0)", "selector option" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.optionFilterDisplay                 = function ( timeout, state, filter_name, option_name, index_line_filter ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAutoRefresh', "" );
        
        setTimeout( function () {
            var _option = self.DOM.getOptionFilter( filter_name, option_name, index_line_filter );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _option, "tag information for <span class='shinken-data-user'>" + property_name + "</span>" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _option, "tag information for <span class='shinken-data-user'>" + property_name + "</span>" );
                    break;
            }
        }, timeout );
        
        return _to_return;
    };
    self.TEST.columnHeaderLabel                   = function ( timeout, column_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.columnHeaderLabel', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.columnHeaderLabel( column_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.headerManagerSubMenuListColumnLabel = function ( timeout, column_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerManagerSubMenuListColumnLabel', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.headerManagerSubMenuListColumn( column_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnAutoRefresh                = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAutoRefresh', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonAutoRefresh() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnRefreshManually            = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnRefreshManually', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonRefreshManual() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnExportCSV                  = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnExportCSV', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, self.DOM.buttonExportCSV() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnSave                       = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.saveList', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, self.DOM.exportSaveButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.setName                           = function ( timeout, name ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setName', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( timeout, self.DOM.inputName(), name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LIST_ALL || {} );

