//__lib__ lib_common
'use strict';


COMPONENT.InterfaceButton           = function () {
};
COMPONENT.InterfaceButton.prototype = {
    init: function ( dom_element ) {
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltip( _tooltip_by_state );
        }
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    addClass         : function ( to_add ) {
        this.dom_element.classList.add( to_add );
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltip       : function ( to_set, type ) {
        if ( to_set ) {
            this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            this.dom_element.setAttribute( 'shi-tip-html', to_set );
            if ( type ) {
                this.dom_element.setAttribute( 'shi-tip-type', type );
            }
        }
        else {
            this.dom_element.setAttribute( 'shi-tip-html', '' );
        }
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
    //********************************************  COMPUTE  ***********************************************//
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, COMPONENT.Interface );


COMPONENT.Button           = function ( dom_element, name ) {
    this.__class_name__ = 'COMPONENT.Button';
    // dom_element
    // value
    // state
    // label
    // name
    this.uuid   = SHINKEN.TOOLS.STRING.buildUUID();
    this.state  = COMPONENT.CONST.BTN_STATE.OFF;
    this.status = COMPONENT.CONST.BTN_STATUS.NONE;
    this.name   = name;
    this.value  = '';
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement: function () {
        this.value = this.dom_element.value;
        if ( this.dom_element.classList.contains( 'shinken-error' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.ERROR;
        }
        else if ( this.dom_element.classList.contains( 'shinken-warning' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.WARNING;
        }
    },
    _computeState: function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, COMPONENT.InterfaceButton );


COMPONENT.ButtonFromData = function ( event_name, class_to_add ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.init( event_name, class_to_add );
};


COMPONENT.ButtonFromData.prototype = {
    init       : function ( event_name, class_to_add ) {
        this.name         = event_name;
        this.class_to_add = class_to_add;
        this.state        = COMPONENT.CONST.BTN_STATE.OFF;
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-label " + this.class_to_add, onclick: "MANAGER.EventManager.clickOnButton(event, '" + this.name + "' )" }, "" ) );
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltip( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonFromData, COMPONENT.InterfaceButton );