//__lib__ lib_common
'use strict';

COMPONENT.InputRange           = function ( dom_element, property ) {
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init: function ( dom_element ) {
        this.dom_element_parent    = dom_element;
        this.dom_input_range       = dom_element.querySelector( ".shinken-range-container input" );
        this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
        this.value                 = 0;
        this.min                   = this.dom_input_range.min;
        this.max                   = this.dom_input_range.max;
        this.unit                  = dom_element.dataset.unit;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter   : function ( event_name, param ) {
        switch ( event_name ) {
            case "value_changed":
                this.setValue( this.dom_input_range.value );
                break;
        }
    },
    setValue        : function ( to_set ) {
        this.value = to_set;
        this.updateLabel();
        DOM.Service.setDataSet( this.dom_element_parent, "value", to_set );
    },
    setValueFromUser: function ( to_set ) {
        this.dom_input_range.value = to_set;
        this.setValue( to_set );
    },
    updateLabel     : function () {
        var _to_set = this.value + this.unit;
        this.component_label_input.updateLabel( _to_set );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue: function () {
        return this.value;
    },
    getUnit : function () {
        return this.unit || "";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );
