//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.BlinkNotificationOfChange = function ( data ) {
    this.init( data );
};

SHINKEN.OBJECT.BlinkNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "change_value_notification_of_change_visual_blink":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED, param );
                break;
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getValue: function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED:
                if ( typeof value === "object" ) {
                    this[ key ] = value.value;
                }
                else {
                    this[ key ] = value;
                }
                break;
        }
    },
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return = {};
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] !== undefined ) {
            _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
        }
        return _to_return;
    },
    //**************************************    HTML         **************************************************//
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #visual-blink-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};