//__lib__ lib_common
'use strict';


SHINKEN.OBJECT.NOTIFICATION.User           = function () {
    this.__class_name__                = 'SHINKEN.OBJECT.NOTIFICATION.USER';
    this.dom_element                   = null;
    this.message                       = null;
    this.timeout_to_close_notification = null;
};
SHINKEN.OBJECT.NOTIFICATION.User.prototype = {
    init                       : function () {
    },
    createNotification         : function ( message, status, skip_close ) {
        this.createMessageDom();
        
        if ( !skip_close ) {
            var _cross = DOM.Service.createElement( 'div', { class: "shinkon shinkon-times-bold" } );
            this.dom_element.appendChild( _cross );
            var self = this;
            _cross.addEventListener( 'click', function () {
                self.close();
            } );
        }
        this.message = message;
        
        if ( status ) {
            this.addTypeToNotification( status );
        }
        var _dom_text_notification = DOM.Service.createElement( 'span', {}, this.message );
        DOM.Service.addElementTo( _dom_text_notification, this.dom_element );
        
    },
    addTypeToNotification      : function ( status ) {
        var _icon = DOM.Service.createElement( 'span', { 'class': "shinkon" } );
        switch ( status ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR:
                _icon.classList.add( 'shinkon-warning' );
                this.dom_element.classList.add( "notification-error" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.WARNING:
                _icon.classList.add( 'shinkon-warning' );
                this.dom_element.classList.add( "notification-warning" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO:
                _icon.classList.add( 'info-circle' );
                this.dom_element.classList.add( "notification-info" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.SUCCESS:
                _icon.classList.add( 'info-circle' );
                this.dom_element.classList.add( "notification-success" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS:
                this.dom_element.classList.add( "shinken-notification-copy-success" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED:
                this.dom_element.classList.add( "shinken-notification-copy-failed" );
                break;
        }
        DOM.Service.addElementTo( _icon, this.dom_element );
    },
    setTimerToCloseNotification: function ( parent_element, time_before_remove ) {
        time_before_remove              = time_before_remove || 8000;
        var self                        = this;
        this.timeoutToCloseNotification = setTimeout( function () {
            self.dom_element.classList.add( "shinken-removed" );
        }, time_before_remove );
    },
    bindToElement              : function ( element, notification_placement ) {
        var _size   = element.getBoundingClientRect();
        var _styles = {};
        switch ( notification_placement ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.TOP:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] - 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 50;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.BOTTOM:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 50;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_TITLE_HIVE: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ];
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_TITLE_LIST: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 55;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ];
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_COPY_WEATHER_JSON:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 35;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 20;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] - 35;
                if ( _styles[ DOM.CONST.STYLE.TOP ] < 0 ) {
                    _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] + 35;
                }
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 25;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED:// TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] - 35;
                if ( _styles[ DOM.CONST.STYLE.TOP ] < 0 ) {
                    _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] + 35;
                }
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 100;
                break;
            default:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ];
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] + 50;
                break;
        }
        DOM.Service.setStyles( this.dom_element, _styles );
    },
    createMessageDom           : function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-notification-popup" } );
    },
    close                      : function () {
        clearTimeout( this.timeoutToCloseNotification );
        DOM.Service.removeElement( this.dom_element );
    }
    
    //********************************************  SETTER GETTER   **************************************************//
    //********************************************  VIEW   **************************************************//
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NOTIFICATION.User, SHINKEN.OBJECT.ShinkenObject );