//__lib__ lib_common
'use strict';

SHINKEN_GRID.Grid           = function ( data ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( data );
};
SHINKEN_GRID.Grid.prototype = {
    init: function ( data ) {
        this.initInternal();
        this.initPhase();
        this.tile_pixel_size = 0;
        this.updateData( data );
        if ( data ) {
            this.max_nb_tiles = this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].getMaxTileInHeight();
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
        }
    },
    //********************************************  JSON  *****************************************************//
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [ SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED, this.getDefaultValueLabel() ] ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT, SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.TYPE, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, [ "grid" ], true ]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS, "SHINKEN_GRID.Cells" ]
        ] );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    onMouseMove : function ( event ) {
    },
    onMouseLeave: function ( event ) {
    },
    onScroll    : function ( event ) {
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].onScroll( event, this );
    },
    mouseWheel  : function ( event ) {
    },
    //********************************************  COMPUTE  *****************************************************//
    computeMapping : function ( mapping ) {
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] instanceof SHINKEN_GRID.Cells ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeMapping( mapping );
        }
    },
    computeSizes   : function () {
        this.computeTileSize();
        this._computeSizes();
        this.updateStyle();
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeSizes( this );
    },
    computeTileSize: function () {
        this.tile_pixel_size = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X );
    },
    _computeSizes  : function () {
        this.computeFontSize();
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    initDomElementHtml: function ( dom_parent ) {
        this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-" + this.uuid, class: "shinken-grid", style: "font-size:" + this.font_size + "px;" } );
    },
    computeHtml       : function () {
        this.initDomElementHtml();
        DOM.Service.addElementTo( this.dom_element, this.dom_element_parent_for_compute );
        DOM.Service.setDataSet( this.dom_element, 'gridUuid', this.uuid );
        
        this.computeTileSize();
        this._computeSizes();
        this.updateStyle();
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeHtml( this );
    },
    updateStyle       : function ( force_hidden ) {
        DOM.Service.setStyles( this.dom_element, this.getComputedStyle() );
    },
    getComputedStyle  : function () {
        var _nb_tiles                           = this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ? this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ) : this.max_nb_tiles;
        var _to_return                          = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ]    = this.tile_pixel_size * _nb_tiles;
        _to_return[ DOM.CONST.STYLE.FONT_SIZE ] = this.font_size;
        return _to_return;
    },
    computeFontSize   : function () {
        this.font_size = parseInt( DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / 85.7 );
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateContentData: function ( data ) {
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].updateContentData( data );
    },
    doActionAfter    : function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-shinken-cell-grid":
            case "focus-on-shinken-cell-grid-from-cell":
                this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].doActionAfter( event_name, param );
                break;
        }
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        if ( this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) ) {
            this.computeHtml();
        }
        else if ( this.getCurrentPhase() != this.getPreviousPhase() ) {
            this.updateStyle();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.PhaseInterface );