# !/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING
from shinken.toolbox.pickledb import ShinkenPickleableMeta

if TYPE_CHECKING:
    from shinkensolutions.data_hub.data_hub import DataHubConfig
    from shinken.misc.type_hint import Dict, Any


class DataHubsBackup(object):
    __metaclass__ = ShinkenPickleableMeta
    
    
    def __init__(self):
        self.data_hubs = {}  # type: Dict[unicode, DataHubBackup]
    
    
    def __iter__(self):
        return self.data_hubs.iteritems()
    
    
    def add_backup(self, data_hub_id, data_hub_backup):
        # type: (unicode, DataHubBackup) -> None
        self.data_hubs[data_hub_id] = data_hub_backup
    
    
    def filter_by_category(self, category):
        # type: (unicode) -> DataHubsBackup
        filtered_data_hubs_backup = DataHubsBackup()
        for data_hub_id, data_hub_backup in self.data_hubs.iteritems():
            if data_hub_backup.data_hub_config.data_hub_category == category:
                filtered_data_hubs_backup.add_backup(data_hub_id, data_hub_backup)
        return filtered_data_hubs_backup


class DataHubBackup(object):
    __metaclass__ = ShinkenPickleableMeta
    
    
    def __init__(self, data_hub_config, data_backup):
        # type: (DataHubConfig, Any) -> None
        self.data_hub_config = data_hub_config
        self.data_backup = data_backup
