#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

import time

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Iterable


class Throttle(object):
    
    def __init__(self, pause_times=None, duration_before_reset=9):
        # type: (Iterable[int], int) -> None
        if not pause_times:
            pause_times = (0, 1, 2, 4, 8)
        
        self.pause_times = pause_times
        self.current_counter = 0
        self.duration_before_reset = duration_before_reset
        self.last_throttle_call_time = 0
    
    
    def throttle(self):
        # type: () -> None
        
        t = time.time()
        if self.last_throttle_call_time and t - self.last_throttle_call_time > self.duration_before_reset:
            self.current_counter = 0
        
        time.sleep(self.pause_times[self.current_counter])
        t = time.time()
        self.last_throttle_call_time = t
        
        self.current_counter += 1
        if self.current_counter >= len(self.pause_times):
            self.current_counter = len(self.pause_times) - 1
