#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2021:
#     Gabes Jean, naparuba@gmail.com
#     Gerhard Lausser, Gerhard.Lausser@consol.de
#     Gregory Starck, g.starck@gmail.com
#     Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.
import time
from collections import namedtuple

from log import PartLogger
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any

MessageRef = namedtuple('MessageRef', ['daemon_name', 'module_name'])


class InterDaemonMessage(object):
    my_type = u'inter-daemon-message'
    
    
    def __init__(self, message_type, message_to, message_from, data):
        # type: (unicode, MessageRef, MessageRef, Any) -> None
        self.message_type = message_type
        self.message_to = message_to
        self.message_from = message_from
        self.made_at = time.time()
        self.data = data
    
    
    def get_message_info(self):
        # type: () -> unicode
        return u'message_type:〖%s〗 message_to:〖%s〗 message_from:〖%s〗 made_at:〖%s〗' % (self.message_type, self.message_to, self.message_from, PartLogger.format_time(self.made_at))
