#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.objects.host import Host
from shinken.objects.broker.broker_item import BrokerItem

if TYPE_CHECKING:
    from shinken.misc.type_hint import Tuple


class BrokerHost(Host, BrokerItem):
    def get_context(self):
        context = BrokerItem.get_context(self)
        if context[0] == u'NOTHING' and context[1] == u'NOTHING':
            if not self.got_business_rule and u'disabled' in self.tags:
                context = u'DISABLED', u'DISABLED'
            elif self.acknowledgement and self.acknowledgement.automatic:
                context = u'INHERITED-ACKNOWLEDGED', u'ACKNOWLEDGED'
        return context
    
    
    def get_ui_status(self):
        # If I'm a cluster, I will give my status
        if self.got_business_rule:
            return self.bp_state
        else:
            return BrokerItem.get_ui_status(self)
    
    
    def get_names(self):
        # type: () -> Tuple[unicode,unicode]
        return self.host_name, u''
