#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import Any, NoReturn, Optional, Callable
from shinkensolutions.api.synchronizer import ShinkenObject
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.html.tag import TagHtml
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.html.label import LabelHtml


class GenericButton(ShinkenObject):
    def __init__(self, translate, value, tag=None, label='', label_object=None):
        # type: (Callable, str, TagHtml, str, LabelHtml)-> NoReturn
        super(GenericButton, self).__init__(translate)
        self._value = value
        self._tag = tag
        self._label = None  # type: Optional[LabelHtml]
        self.set_label(label_object or label)
        self._onclick = 'MANAGER.EventManager.clickOnButton(event)'
        self._internal_class = 'shinken-button'
        self._attribute = ''
    
    
    def set_onclick(self, to_set):
        # type: (str)-> NoReturn
        self._onclick = to_set
    
    
    def set_value(self, to_set):
        # type: (str)-> NoReturn
        self._value = to_set
    
    
    def set_label(self, to_set):
        # type: (Any)-> NoReturn
        if isinstance(to_set, basestring):
            self._label = LabelHtml(to_set)
        else:
            self._label = to_set
    
    
    def set_tag(self, to_set):
        # type: (TagHtml)-> NoReturn
        self._tag = to_set
    
    
    def set_class(self, to_set):
        # type: (str)-> NoReturn
        self._internal_class = to_set
    
    
    def add_class(self, to_set):
        # type: (str)-> NoReturn
        self._internal_class = '''%s %s''' % (self._internal_class, to_set)
    
    
    def add_attribute(self, to_set):
        # type: (str)-> NoReturn
        self._attribute = '''%s %s''' % (self._attribute, to_set)
    
    
    def get_html(self):
        # type: ()-> str
        _to_return = ['''%s''' % (self._tag.get_opening_tag_html() if self._tag else ''),
                      ''' <div class="%s" onclick="%s" value="%s" %s>''' % (self._internal_class, self._onclick, self._value, self._attribute),
                      self.wrap_in_middle_vertical_align_container(self._label.get_html()),
                      ''' </div>''',
                      '''%s''' % (self._tag.get_closing_tag_html() if self._tag else '')
                      ]
        return ''.join(_to_return)
    
    
    def get_html_as_label(self):
        # type: ()-> str
        _to_return = ['''%s''' % (self._tag.get_opening_tag_html() if self._tag else ''),
                      ''' <div class="%s" %s>''' % (self._internal_class, self._attribute),
                      self.wrap_in_middle_vertical_align_container(self._label.get_html()),
                      ''' </div>''',
                      '''%s''' % (self._tag.get_closing_tag_html() if self._tag else '')
                      ]
        return ''.join(_to_return)
