#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.component.option_select import OptionSelectComp
from shinken.misc.type_hint import NoReturn, Any
from shinkensolutions.api.synchronizer import ComponentManagerSyncui
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.counter import Counter
from shinkensolutions.api.synchronizer import ITEM_TYPE


class SELECTOR_CONST(object):
    FILTER_COUNTERS = "__filter_counters__"
    FILTER_ITEM_TYPES = "__filter_item_types__"
    FILTER_DEFINE_BY = "__filter_define_by__"
    ALL = "___ALL___"
    EMPTY = "___EMPTY___"
    NOT_EMPTY = "___NOT_EMPTY___"


class OptionDistributor(object):
    def __init__(self):
        # type: ()-> NoReturn
        self.contents = {}
        self.content = {}
        self.filter_counters = None
        self.filter_item_types = None
        self.filter_define_by = None
    
    
    def add_element(self, _id_, to_add):
        # type: (str,Any)-> NoReturn
        self.contents[_id_] = to_add
    
    
    def get_element(self, _id_):
        # type: (str)-> Any
        return self.contents[_id_]
    
    
    def find_element(self, _id_):
        # type: (str)-> Any
        if _id_ not in self.contents:
            if _id_ == SELECTOR_CONST.FILTER_COUNTERS:
                self.add_element(_id_, CounterSelect())
            elif _id_ == SELECTOR_CONST.FILTER_ITEM_TYPES:
                self.add_element(_id_, ItemTypes())
            elif _id_ == SELECTOR_CONST.FILTER_DEFINE_BY:
                self.add_element(_id_, DefineBy())
        return self.get_element(_id_)


instance_option_distributor = OptionDistributor()


# *****************************   FILTERS  ************************************************************#
class CounterSelect:
    DEFAULT = SELECTOR_CONST.ALL
    EMPTY = SELECTOR_CONST.EMPTY
    NOT_EMPTY = SELECTOR_CONST.NOT_EMPTY
    ERROR = "ERROR"
    WARNING = "WARNING"
    LIST = [DEFAULT, EMPTY, ERROR, WARNING, NOT_EMPTY]
    
    
    def __init__(self):
        self.entries = []
        self.translator = ComponentManagerSyncui.get_translate_component().translator()
        for _current in CounterSelect.LIST:
            _to_add = OptionSelectComp('counters', _current, 'user')
            _label = "" if _current == CounterSelect.NOT_EMPTY else self.translator.translate('mass-change.input.counters.%s' % _current)
            if _current == CounterSelect.EMPTY:
                _to_add.set_text(_label)
                _to_add.set_label(_label)
            elif _current == CounterSelect.DEFAULT:
                _to_add.set_text(_label)
                _to_add.set_label(_label)
            elif _current == CounterSelect.ERROR:
                _error_counter = Counter("shinken-error-counter", number=_label, extra_attribute="data-is-discreet='1'")
                _to_add.set_text(_error_counter.get_html())
                _to_add.set_label("<span class='shinken-counter shinken-error-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>")
            elif _current == CounterSelect.WARNING:
                _warning_counter = Counter("shinken-warning-counter", number=_label, extra_attribute="data-is-discreet='1'")
                _to_add.set_text(_warning_counter.get_html())
                _to_add.set_label("<span class='shinken-counter shinken-warning-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>")
            elif _current == CounterSelect.NOT_EMPTY:
                _error_counter = Counter("shinken-error-counter", number=self.translator.translate('mass-change.input.counters.ERROR'), extra_attribute="data-is-discreet='1'")
                _warning_counter = Counter("shinken-warning-counter", number=self.translator.translate('mass-change.input.counters.WARNING'), extra_attribute="data-is-discreet='1'")
                _to_add.set_text("%s&%s" % (_error_counter.get_html(), _warning_counter.get_html()))
                _label1 = "<span class='shinken-counter shinken-error-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>"
                _label2 = "<span class='shinken-counter shinken-warning-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>"
                _to_add.set_label("%s%s" % (_label1, _label2))
            self.entries.append(_to_add)


class ItemTypes:
    DEFAULT = "___ALL___"
    LIST = ITEM_TYPE.ALL_TYPES
    
    
    def __init__(self):
        self.translator = ComponentManagerSyncui.get_translate_component().translator()
        self.entries = [OptionSelectComp('item_types', i, 'user', label=self.translator.translate('type.%s' % i)) for i in ItemTypes.LIST]
        self.entries.sort(key=lambda x: x.get_label())
        self.entries.insert(0, OptionSelectComp('item_types', ItemTypes.DEFAULT, 'user', label=self.translator.translate('type.%s' % ItemTypes.DEFAULT)))


class DefineBy:
    DEFAULT = "___ALL___"
    BY_DEFAULT = "define_by_default"
    BY_USER = "define_by_user"
    BY_USER_AND_DISABLE = "define_by_user_and_disable"
    LIST = [DEFAULT, BY_DEFAULT, BY_USER, BY_USER_AND_DISABLE]
    
    
    def __init__(self):
        self.translator = ComponentManagerSyncui.get_translate_component().translator()
        self.entries = [OptionSelectComp('item_types', i, 'user', label=self.translator.translate('common.%s' % i)) for i in DefineBy.LIST]
