#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn


class LabelHtml(object):
    def __init__(self, label='', hover_label=''):
        # type: (str, str)-> NoReturn
        self._label = label
        self._hover_label = hover_label
        self._internal_class = 'shinken-label-with-hover'
        self._before_html = ''
        self._after_html = ''
    
    
    def set_value(self, to_set):
        # type: (str)-> NoReturn
        self._label = to_set
    
    
    def add_class(self, to_set):
        # type: (str)-> NoReturn
        self._internal_class = "%s %s" % (self._internal_class, to_set)
    
    
    def get_html(self, extra_label=""):
        # type: ()-> str
        _to_return = [self._before_html]
        if self._label and self._hover_label:
            _to_return.append('''<span class="%s">''' % self._internal_class)
            _to_return.append('''<span class="shinken-label-with-hover-false">%s</span>''' % self._label)
            _to_return.append('''<span class="shinken-label-with-hover-true">%s</span>''' % self._hover_label)
            _to_return.append('''</span>''')
        else:
            _to_return.append(self._label)
        _to_return.append(self._after_html)
        return ''.join(_to_return)
