#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from abc import ABCMeta, abstractmethod

from shinken.log import PartLogger
from shinkensolutions.api.synchronizer import ComponentManagerSynchronizer
from shinkensolutions.api.synchronizer.source.source_info import SourceInfo


class AbstractRoute(object):
    __metaclass__ = ABCMeta
    
    
    def __init__(self, logger, source_name, name, share_info, have_http_template=False):
        # type: (PartLogger, str, str, SourceInfo, bool) -> None
        self.logger = logger
        self.source_name = source_name
        self.name = name
        self.have_http_template = have_http_template
        self.http_template = '%s.tpl' % name
        self.share_info = share_info
        
        configuration_component = ComponentManagerSynchronizer.get_configuration_component()
        self.http_start_time = configuration_component.http_start_time
    
    
    @abstractmethod
    def controller(self):
        raise NotImplementedError()
    
    
    def get_route(self):
        return '/sources/%s/%s' % (self.source_name, self.name)
    
    
    def have_http_template(self):
        return self.have_http_template
    
    
    def get_template(self):
        return self.http_template
