SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_DATA = (function ( self ) {
    self.DOM                        = {};
    self.ACTION                     = {};
    self.TEST                       = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.getButtonAddData       = function () {
        return document.querySelector( "#id-shinken-mass-change-tunnel-step3 .shinken-add-data-button-container" );
    };
    self.DOM.getGroupDataList       = function () {
        return document.querySelectorAll( "#id-shinken-mass-change-tunnel-step3 #id-shinken-data-groups-list .shinken-data-group" );
    };
    self.DOM.getGroupDataByUuid     = function ( data_group_uuid ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step3 #id-shinken-data-groups-list .shinken-data-group[data-uuid="' + data_group_uuid + '"]' );
    };
    self.DOM.getFirstNewData        = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step3 .shinken-element-property-line[data-status="' + PROPERTY.CONST.DATA.STATUS.NEW + '"]' );
    };
    self.DOM.getAllDataLines        = function () {
        return document.querySelectorAll( '#id-shinken-mass-change-tunnel-step3 .shinken-element-property-line[data-type="data"]' );
    };
    self.DOM.getFilterInput         = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step3 #id-shinken-data-prop-table .shinken-list-filter[data-name="data_name"] .shinken-input' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.removeFirstData     = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getFirstNewData().querySelector( '.shinken-delete-data-icon' ) );
        }, timeout );
        return 2000;
    };
    self.ACTION.addNewData          = function ( timeout, name, value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getButtonAddData() );
            if ( name !== undefined || value !== undefined ) {
                setTimeout( function () {
                    var _dom_element = self.DOM.getFirstNewData();
                    if ( name !== undefined ) {
                        SHINKEN.TOOLS.TEST_AUTO_PROPERTY_DATA.ACTION.setKeyValue( 0, _dom_element.dataset.name, name );
                    }
                    if ( value !== undefined ) {
                        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.ACTION.setValue( 0, _dom_element.dataset.name, value );
                    }
                }, 1000 );
            }
        }, timeout );
        return 2000;
    };
    self.ACTION.clickOnGroupData    = function ( timeout, uuid ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getGroupDataByUuid( uuid ) );
        }, timeout );
        return 2000;
    };
    self.ACTION.addFilterValue      = function ( timeout, filter_value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.getFilterInput(), filter_value );
        }, timeout );
        return 2000;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.countDisplayedData    = function ( timeout, nb_expected ) {
        setTimeout( function () {
            var _list              = self.DOM.getAllDataLines();
            var _counter_displayed = 0;
            for ( var i = 0, _size_i = _list.length; i < _size_i; i++ ) {
                if ( DOM.Service.isVisible( _list[ i ] ) ) {
                    _counter_displayed++;
                }
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _counter_displayed, nb_expected, "nb data property visible" );
        }, timeout );
        return 200;
    };
    self.TEST.validGroupDataList    = function ( timeout, nb_entries_gp_data ) {
        setTimeout( function () {
            var _list = self.DOM.getGroupDataList();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _list, nb_entries_gp_data, "nb group data" );
        }, timeout );
        return 200;
    };
    self.TEST.validGroupDataCounter = function ( timeout, data_group_uuid, nb_error, nb_warning, nb_user, nb_total ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.counter( 0, self.DOM.getGroupDataByUuid( data_group_uuid ), nb_error, nb_warning, nb_user, nb_total );
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_DATA || {} );