SHINKEN.TOOLS.TEST_AUTO_WEATHER = (function ( self ) {
    self.DOM                              = {};
    self.DOM.IFRAME                       = {};
    self.TEST                             = {};
    self.TEST.IFRAME                      = {};
    self.TEST.WIDGET                      = {};
    self.TEST.WEATHER_GRID_CELL           = {};
    self.TEST.JS                          = {};
    self.ACTION                           = {};
    self.CONST                            = {
        STATE_DISPLAY    : {
            HIDDEN                           : 0,
            VISIBLE                          : 1,
            VISIBLE_AND_DISABLED             : 2,
            VISIBLE_AND_CHILDREN_DISABLED    : 3,
            VISIBLE_AND_DISABLED_AND_NO_EVENT: 4
            
        },
        WEATHER_GRID_CELL: {
            STATE: {
                HIDDEN               : 0,
                VISIBLE              : 1,
                HAS_WARNING          : 2,
                HAS_ERROR            : 3,
                HAS_WARNING_AND_ERROR: 4,
                KEY                  : {
                    0: "HIDDEN",
                    1: "VISIBLE",
                    2: "HAS_WARNING",
                    3: "HAS_ERROR",
                    4: "HAS_WARNING_AND_ERROR"
                }
            }
            
        }
    };
    //********************************************  GET DOM ELEMENT IFRAME  **************************************************//
    self.DOM.IFRAME.getIframe             = function () {
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document.querySelector( "#id-shinken-iframe" ).contentWindow.document;
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.pageContainer                = function ( in_iframe ) {
        return in_iframe ? self.DOM.IFRAME.getIframe().getElementById( 'id-shinken-page-container' ) : document.getElementById( 'id-shinken-page-container' );
    };
    self.DOM.infoBar                      = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( '.shinken-info-bar' );
    };
    self.DOM.infoBarShinkenLogo           = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( '.shinken-logo' );
    };
    self.DOM.infoBarGenerateAt            = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( '.shinken-generate-at' );
    };
    self.DOM.infoBarTimer                 = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( '.shinken-container-clock' );
    };
    self.DOM.infoBarSoundNotification     = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( '.shinken-sound-notification-container' );
    };
    self.DOM.infoBarBlinkNotification     = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( '.shinken-blink-notification-container' );
    };
    self.DOM.getElement                   = function ( type_element, in_iframe ) {
        switch ( type_element ) {
            case 'button_mode_edit':
            case 'button_back_to_previous_preview':
            case 'button_external_links':
            case 'popup_external_links':
                return SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.DOM.getElement( type_element, in_iframe );
            case 'logo_shinken':
                return self.DOM.infoBarShinkenLogo( in_iframe );
            case 'generate_at':
                return self.DOM.infoBarGenerateAt( in_iframe );
            case 'timer_icon':
                return self.DOM.infoBarTimer( in_iframe );
            case 'sound_notification_container':
                return self.DOM.infoBarSoundNotification( in_iframe );
            case 'blink_notification_container':
                return self.DOM.infoBarBlinkNotification( in_iframe );
        }
    };
    self.DOM.getAllWidgets                = function () {
        return self.DOM.pageContainer().querySelectorAll( ".shinken-widget" );
    };
    self.DOM.getAllGridElementWithErrors  = function ( data_set ) {
        return DOM.Service.querySelectorAllWithData( ".shinken-grid-cell[data-nb-error]", "nbError", self.DOM.pageContainer() );
    };
    self.DOM.getAllGridElementWithWarning = function () {
        return DOM.Service.querySelectorAllWithData( ".shinken-grid-cell[data-nb-warning]", "nbWarning", self.DOM.pageContainer() );
    };
    self.DOM.getAllWidgetsSeparators      = function () {
        return self.DOM.pageContainer().querySelectorAll( "[data-type=\"separator_widget\"]" );
    };
    
    self.DOM.getWidgetSeparator = function ( index ) {
        return self.DOM.getAllWidgetsSeparators()[ index ];
    };
    self.DOM.getWidgetTitle     = function () {
        return self.DOM.self.DOM.pageContainer().querySelector( '[data-type="separator_widget"]' );
    };
    self.DOM.getWidgetWeather   = function () {
        return self.DOM.pageContainer().querySelector( '[data-type="weather_widget"]' );
    };
    self.DOM.getWidget          = function ( widget_type, widget_index ) {
        switch ( widget_type ) {
            case WIDGET.CONST.TYPE.SEPARATOR:
                return self.DOM.getWidgetSeparator( widget_index );
            case WIDGET.CONST.TYPE.TITLE:
                return self.DOM.getWidgetTitle();
            case WIDGET.CONST.TYPE.WEATHER:
                return self.DOM.getWidgetWeather( widget_index );
        }
    };
    self.DOM.getWidgetArea      = function ( widget_type, widget_index, widget_area ) {
        var _dom = self.DOM.getWidget( widget_type, widget_index );
        switch ( widget_area ) {
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY:
                return _dom.querySelector( '.shinken-cell-left' );
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA._KEY:
                return _dom.querySelector( '.shinken-cell-right' );
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA._KEY:
                return _dom.querySelector( '.shinken-cell-top-right-area' );
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY:
                return _dom.querySelector( '.shinken-widget-separator-title' );
        }
    };
    
    
    
    //self.DOM.getWidgetTitleTitleArea       = function () {
    //    return self.DOM.getWidgetTitle().querySelector(".shinken-widget-title-content");
    //};
    //self.DOM.getWidgetWeatherNameArea       = function () {
    //    return self.DOM.getWidgetWeather().querySelector(".shinken-widget-title-content");
    //};
    
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.displayState            = function ( timeout, type_element, state, in_iframe ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayState', state, type_element );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getElement( type_element, in_iframe );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "1" );
                    break;
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, type_element );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_DISABLED_AND_NO_EVENT:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "pointerEvents", 'none' );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_CHILDREN_DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom.firstElementChild, "pointerEvents", 'none' );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.IFRAME.displayState     = function ( timeout, type_element, state ) {
        return self.TEST.displayState( timeout, type_element, state, true );
    };
    self.TEST.WIDGET.count            = function ( timeout, total_number_element_expected, number_with_errors, number_with_warning ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.WIDGET.count', total_number_element_expected + "-" + number_with_errors + "-" + number_with_warning );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllWidgets(), total_number_element_expected, "total number widget" );
            if ( number_with_errors !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllGridElementWithErrors(), number_with_errors, "error number widget" );
            }
            if ( number_with_warning !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllGridElementWithWarning(), number_with_warning, "warning number widget" );
            }
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.stateArea        = function ( timeout, widget_type, widget_index, widget_area, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.stateArea', widget_area + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = self.DOM.getWidgetArea( widget_type, widget_index, widget_area );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNoWidth( 0, _dom_element, widget_area );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element, widget_area );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WEATHER_GRID_CELL.state = function ( timeout, cell_index, state ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.WEATHER_GRID_CELL.state', self.CONST.WEATHER_GRID_CELL.STATE.KEY[ state ] );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _cells       = document.querySelectorAll( ".shinken-grid-cell" );
            var _dom_element = _cells[ cell_index ];
            switch ( state ) {
                case self.CONST.WEATHER_GRID_CELL.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_element );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.HAS_WARNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "nbWarning" );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.HAS_ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "nbError" );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.HAS_WARNING_AND_ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "nbError" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "nbWarning" );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    self.TEST.WIDGET.contentArea = function ( timeout, widget_type, widget_index, widget_area, content ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.contentArea', widget_area + " --> " + content );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = self.DOM.getWidgetArea( widget_type, widget_index, widget_area ).querySelector( ".shinken-primary-icon" );
            var _style       = "";
            switch ( content ) {
                case WIDGET.CONST.WEATHER.ENUM.TOP_RIGHT_AREA_ICON_TYPE.STATUS_THEN_CONTEXT:
                case WIDGET.CONST.WEATHER.ENUM.TOP_RIGHT_AREA_ICON_TYPE.QUALITY_SERVICE_ICON:
                case WIDGET.CONST.WEATHER.ENUM.TOP_RIGHT_AREA_ICON_TYPE.ONLY_STATUS:
                case WIDGET.CONST.WEATHER.ENUM.TOP_RIGHT_AREA_ICON_TYPE.CONTEXT_THEN_STATUS:
                case WIDGET.CONST.WEATHER.ENUM.TOP_RIGHT_AREA_ICON_TYPE.FROM_WEBUI:
                    _style = "rgba(0, 0, 0, 0) url(\"http://" + SHINKEN.HIGHWAY.getHost() + "/static/" + __SHINKEN_HTTP_START_TIME__ + "/img/icons/critical.svg\") no-repeat scroll 50% 50% / auto padding-box border-box";
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_element, "background", _style );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.textColor   = function ( timeout, widget_type, widget_index, widget_area, color ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.changeColorInTitleArea' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "color", color );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.textAlign   = function ( timeout, widget_type, widget_index, widget_area, alignment ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.changeColorInTitleArea' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "text-align", alignment );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //********************************************  ACTION   **************************************************//
    self.ACTION.createWeather = function ( timeout, name, user_name ) {
        var _to_return = 3000 + 2000 + 1000 + 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.createWeather', name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _timeout = SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.ACTION.clickOnSubMenu( 0, SHINKEN.SCREEN.TYPE.SERVICE_WEATHER, "menu_expand_new_service_weather" );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.clickOnButton( _timeout, 'button_mode_edit' );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.createJSONInForm( _timeout, name, user_name );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.clickOnButton( _timeout, 'button_save' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER || {} );
