SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE = (function ( self ) {
    self.DOM                  = {};
    self.TEST                 = {};
    self.ACTION               = {};
    var _INTERNAL             = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.document         = function ( navigator ) {
        return navigator ? navigator.document : document;
    };
    self.DOM.licenceContainer = function ( navigator ) {
        return self.DOM.document( navigator ).getElementById( "id-shinken-license-container" );
    };
    self.DOM.licenceContactUs = function ( navigator ) {
        return self.DOM.licenceContainer( navigator ).querySelector( ".shinken-license-col-contact" );
    };
    self.DOM.licenceContent   = function ( navigator ) {
        return self.DOM.licenceContainer( navigator ).querySelector( ".shinken-license-col-content" );
    };
    self.DOM.licenceIcon      = function ( navigator ) {
        return self.DOM.licenceContainer( navigator ).querySelector( ".shinken-license-col-icon-icon" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.display            = function ( timeout, state, navigator_container ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setConfiguration', state );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var navigator = navigator_container ? navigator_container.instance : null;
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isEmpty( 0, self.DOM.licenceContainer( navigator ) );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_60_DAYS:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.GREEN, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), "La licence se termine le", "60 jours restant(s)"], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_7_DAYS:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.GREEN, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), "La licence se termine le", "7 jours restant(s)"], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.NO_LICENCE:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.RED, [_( 'license.licenseInvalid', [DICTIONARY_COMMON_UI] ), _( 'license.noLicenseKey', [DICTIONARY_COMMON_UI] ), _( 'license.onServer', [DICTIONARY_COMMON_UI] )], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.IS_DUPLICATED_TRIAL:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.RED, [_( 'license.licenseInvalid', [DICTIONARY_COMMON_UI] ), _( 'license.youAreUsingSecondTime', [DICTIONARY_COMMON_UI] ), _( 'license.aTrialVersion', [DICTIONARY_COMMON_UI] )], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.INVALID_FORMAT:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.RED, [_( 'license.licenseInvalid', [DICTIONARY_COMMON_UI] ), _( 'license.yourLicenseHas', [DICTIONARY_COMMON_UI] ), _( 'license.invalidFormat', [DICTIONARY_COMMON_UI] )], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.LICENSE_EXPIRED:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.RED, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), _( 'license.expired', [DICTIONARY_COMMON_UI] ), _( 'license.licensePeriod', [DICTIONARY_COMMON_UI] )], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.NODE_LIMIT_EXCEEDED:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.RED, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), "Hôtes: 150 / 140 [ dépassé de 10 ]"], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.LESS_THAN_10_PERCENT_OF_THE_HOST_LIMIT:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.GREEN, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), "Hôtes: 150 / 155 [ 5 restant(s) ]"], self.CONST.ICON.NINJA_BLUE, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.TESTING_VERSION:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.GREEN, [_( 'license.licenseTypeTrial', [DICTIONARY_COMMON_UI] ), "La licence se termine le", "[90 jours restant(s) ]"], self.CONST.ICON.NINJA_BLUE, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_60_DAYS_AND_NODE_LIMIT_EXCEEDED:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.RED, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), "La licence se termine le", "60 jours restant(s)", "Hôtes: 150 / 140 [ dépassé de 10 ]"], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_60_DAYS_AND_LESS_THAN_10_PERCENT_OF_THE_HOST_LIMIT:
                    _INTERNAL.display( self.CONST.BACKGROUND_COLOR.GREEN, [_( 'license.licenseTypePro', [DICTIONARY_COMMON_UI] ), "La licence se termine le", "60 jours restant(s)", "Hôtes: 150 / 155 [ 5 restant(s) ]"], self.CONST.ICON.NINJA_RED, navigator );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    _INTERNAL.display            = function ( background_color, texts, icon, navigator ) {
        _INTERNAL.displayContactUs( background_color, navigator );
        _INTERNAL.displayContent( texts, navigator );
        _INTERNAL.displayIcon( icon, navigator );
    };
    _INTERNAL.displayContactUs   = function ( background_color, navigator ) {
        var _dom_contact_us = self.DOM.licenceContactUs( navigator );
        if ( !CONTROLLER.UiVisualisation.current_user.isAdmin() ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_contact_us );
        }
        else {
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_contact_us );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_contact_us, "background-color", background_color );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, _dom_contact_us, _( 'license.contactUs', [DICTIONARY_COMMON_UI] ) );
        }
    };
    _INTERNAL.displayContent     = function ( texts, navigator ) {
        var _dom_content = self.DOM.licenceContent( navigator );
        SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_content );
        SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_content, "background-color", self.CONST.BACKGROUND_COLOR.LIGHT_GREY );
        for ( var i = 0, _size_i = texts.length; i < _size_i; i++ ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, _dom_content, texts[ i ] );
        }
    };
    _INTERNAL.displayIcon        = function ( icon, navigator ) {
        var _dom_icon = self.DOM.licenceIcon( navigator );
        SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_icon );
        SHINKEN.TOOLS.TEST_AUTO_DOM.hasAttributeContains( 0, _dom_icon, "src", icon );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.setConfiguration = function ( timeout, to_set, navigator_container ) {
        var _to_return = 1500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setConfiguration', to_set );
        setTimeout( function () {
            var navigator   = navigator_container ? navigator_container.instance : null;
            var _controller = navigator ? navigator.CONTROLLER.License : CONTROLLER.License;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _controller.updateData( _INTERNAL.computeData( to_set ) );
            _controller.computeHtml();
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  INTERNAL **************************************************//
    _INTERNAL.computeData        = function ( test_case ) {
        var _to_return = {
            creation_time      : (Date.now() / 1000),
            customer_email     : "root@localhost",
            customer_name      : "TEST:lab-validation",
            duration           : 86400 * 90,
            is_duplicated_trial: false,
            is_format_valid    : true,
            is_key_valid       : true,
            is_present         : true,
            is_testing         : false,
            is_trial           : false,
            nb_clusters        : 200,
            nb_hosts           : 150,
            nodes_limit        : 1000
        };
        switch ( test_case ) {
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_60_DAYS:
                _to_return.duration = 86400 * 60;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_7_DAYS:
                _to_return.duration = 86400 * 7;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.NO_LICENCE:
                _to_return.is_key_valid = false;
                _to_return.is_present   = false;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.IS_DUPLICATED_TRIAL:
                _to_return.is_duplicated_trial = true;
                _to_return.is_key_valid        = false;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.INVALID_FORMAT:
                _to_return.is_format_valid = false;
                _to_return.is_key_valid    = false;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.LICENSE_EXPIRED:
                _to_return.duration = 0;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.NODE_LIMIT_EXCEEDED:
                _to_return.nodes_limit = 140;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.LESS_THAN_10_PERCENT_OF_THE_HOST_LIMIT:
                _to_return.nodes_limit = 155;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.TESTING_VERSION:
                _to_return.is_testing = true;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_60_DAYS_AND_NODE_LIMIT_EXCEEDED:
                _to_return.duration    = 86400 * 60;
                _to_return.nodes_limit = 140;
                break;
            case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST.STATE.REMAINING_60_DAYS_AND_LESS_THAN_10_PERCENT_OF_THE_HOST_LIMIT:
                _to_return.duration    = 86400 * 60;
                _to_return.nodes_limit = 155;
                break;
        }
        return _to_return;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE || {} );

SHINKEN.TOOLS.TEST_AUTO_UI_VISU_LICENCE.CONST = {
    STATE           : {
        HIDDEN                                                      : "all_is_ok",
        REMAINING_60_DAYS                                           : "remaining_60_days",
        REMAINING_7_DAYS                                            : "remaining_7_days",
        NO_LICENCE                                                  : "no-licence",
        IS_DUPLICATED_TRIAL                                         : "is_duplicated_trial",
        INVALID_FORMAT                                              : "invalid_format",
        LICENSE_EXPIRED                                             : "license_expired",
        NODE_LIMIT_EXCEEDED                                         : "node_limit_expired",
        LESS_THAN_10_PERCENT_OF_THE_HOST_LIMIT                      : "less_than_10_percent_of_the_host_limit",
        TESTING_VERSION                                             : "testing_version",
        REMAINING_60_DAYS_AND_NODE_LIMIT_EXCEEDED                   : "remaining_60_days_and_node_limit_exceeded",
        REMAINING_60_DAYS_AND_LESS_THAN_10_PERCENT_OF_THE_HOST_LIMIT: "remaining_60_days_and_less_than_10_percent_of_the_host_limit"
    },
    BACKGROUND_COLOR: {
        GREEN     : "rgb(76, 183, 62)",
        RED       : "rgb(255, 58, 58)",
        LIGHT_GREY: "rgb(220, 220, 220)"
    },
    ICON            : {
        NINJA_RED : "ninja-red.png",
        NINJA_BLUE: "ninja-blue.png"
    }
};